/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.SerializableStatement;
import com.couchbase.client.java.query.Statement;

@InterfaceAudience.Private
@InterfaceStability.Experimental
public class PreparedPayload
implements SerializableStatement {
    private static final long serialVersionUID = -5950676152745796617L;
    private final String preparedName;
    private final SerializableStatement originalStatement;
    private final String encodedPlan;

    public PreparedPayload(Statement originalStatement, String preparedName, String encodedPlan) {
        this.originalStatement = originalStatement instanceof SerializableStatement ? (SerializableStatement)originalStatement : new N1qlQuery.RawStatement(originalStatement.toString());
        this.preparedName = preparedName;
        this.encodedPlan = encodedPlan;
    }

    public String payload() {
        return this.preparedName;
    }

    public String encodedPlan() {
        return this.encodedPlan;
    }

    public String preparedName() {
        return this.preparedName;
    }

    public SerializableStatement originalStatement() {
        return this.originalStatement;
    }

    public String toString() {
        return this.payload();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedPayload that = (PreparedPayload)o;
        if (this.preparedName != null ? !this.preparedName.equals(that.preparedName) : that.preparedName != null) {
            return false;
        }
        if (this.originalStatement != null ? !this.originalStatement.equals(that.originalStatement) : that.originalStatement != null) {
            return false;
        }
        return !(this.encodedPlan == null ? that.encodedPlan != null : !this.encodedPlan.equals(that.encodedPlan));
    }

    public int hashCode() {
        int result = this.preparedName != null ? this.preparedName.hashCode() : 0;
        result = 31 * result + (this.originalStatement != null ? this.originalStatement.hashCode() : 0);
        result = 31 * result + (this.encodedPlan != null ? this.encodedPlan.hashCode() : 0);
        return result;
    }
}

