/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.BackpressureException;
import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.RequestEvent;
import com.couchbase.client.core.RequestEventFactory;
import com.couchbase.client.core.RequestHandler;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseEventFactory;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.DefaultConfigurationProvider;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.DefaultCoreEnvironment;
import com.couchbase.client.core.env.Diagnostics;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.CloseBucketRequest;
import com.couchbase.client.core.message.cluster.CloseBucketResponse;
import com.couchbase.client.core.message.cluster.ClusterRequest;
import com.couchbase.client.core.message.cluster.DisconnectRequest;
import com.couchbase.client.core.message.cluster.DisconnectResponse;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.cluster.OpenBucketRequest;
import com.couchbase.client.core.message.cluster.OpenBucketResponse;
import com.couchbase.client.core.message.cluster.SeedNodesRequest;
import com.couchbase.client.core.message.cluster.SeedNodesResponse;
import com.couchbase.client.core.message.internal.AddNodeRequest;
import com.couchbase.client.core.message.internal.AddNodeResponse;
import com.couchbase.client.core.message.internal.AddServiceRequest;
import com.couchbase.client.core.message.internal.AddServiceResponse;
import com.couchbase.client.core.message.internal.GetConfigProviderRequest;
import com.couchbase.client.core.message.internal.GetConfigProviderResponse;
import com.couchbase.client.core.message.internal.InternalRequest;
import com.couchbase.client.core.message.internal.RemoveNodeRequest;
import com.couchbase.client.core.message.internal.RemoveNodeResponse;
import com.couchbase.client.core.message.internal.RemoveServiceRequest;
import com.couchbase.client.core.message.internal.RemoveServiceResponse;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.EventTranslatorOneArg;
import com.couchbase.client.deps.com.lmax.disruptor.ExceptionHandler;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.com.lmax.disruptor.dsl.Disruptor;
import com.couchbase.client.deps.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import rx.Observable;
import rx.functions.Func1;

public class CouchbaseCore
implements ClusterFacade {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseCore.class);
    private static final EventTranslatorOneArg<RequestEvent, CouchbaseRequest> REQUEST_TRANSLATOR = new EventTranslatorOneArg<RequestEvent, CouchbaseRequest>(){

        @Override
        public void translateTo(RequestEvent event, long sequence, CouchbaseRequest request) {
            event.setRequest(request);
        }
    };
    private static final BackpressureException BACKPRESSURE_EXCEPTION = new BackpressureException();
    private final RingBuffer<RequestEvent> requestRingBuffer;
    private final RequestHandler requestHandler;
    private final ConfigurationProvider configProvider;
    private final CoreEnvironment environment;
    private final Disruptor<RequestEvent> requestDisruptor;
    private final Disruptor<ResponseEvent> responseDisruptor;
    private final ExecutorService disruptorExecutor;
    private volatile boolean sharedEnvironment = true;

    public CouchbaseCore() {
        this(DefaultCoreEnvironment.create());
        this.sharedEnvironment = false;
    }

    public CouchbaseCore(CoreEnvironment environment) {
        LOGGER.info(environment.toString());
        LOGGER.debug(Diagnostics.collectAndFormat());
        this.environment = environment;
        this.configProvider = new DefaultConfigurationProvider(this, environment);
        this.disruptorExecutor = Executors.newFixedThreadPool(2, new DefaultThreadFactory("cb-core", true));
        this.responseDisruptor = new Disruptor<ResponseEvent>(new ResponseEventFactory(), environment.responseBufferSize(), this.disruptorExecutor);
        this.responseDisruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
                LOGGER.warn("Exception while Handling Response Events {}", event, (Object)ex);
            }

            @Override
            public void handleOnStartException(Throwable ex) {
                LOGGER.warn("Exception while Starting Response RingBuffer", ex);
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
                LOGGER.info("Exception while shutting down Response RingBuffer", ex);
            }
        });
        this.responseDisruptor.handleEventsWith(new ResponseHandler(environment, this, this.configProvider));
        this.responseDisruptor.start();
        RingBuffer<ResponseEvent> responseRingBuffer = this.responseDisruptor.getRingBuffer();
        this.requestDisruptor = new Disruptor<RequestEvent>(new RequestEventFactory(), environment.requestBufferSize(), this.disruptorExecutor);
        this.requestHandler = new RequestHandler(environment, this.configProvider.configs(), responseRingBuffer);
        this.requestDisruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
                LOGGER.warn("Exception while Handling Request Events {}", event, (Object)ex);
            }

            @Override
            public void handleOnStartException(Throwable ex) {
                LOGGER.warn("Exception while Starting Request RingBuffer", ex);
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
                LOGGER.info("Exception while shutting down Request RingBuffer", ex);
            }
        });
        this.requestDisruptor.handleEventsWith(this.requestHandler);
        this.requestDisruptor.start();
        this.requestRingBuffer = this.requestDisruptor.getRingBuffer();
    }

    @Override
    public <R extends CouchbaseResponse> Observable<R> send(CouchbaseRequest request) {
        if (request instanceof InternalRequest) {
            this.handleInternalRequest(request);
            return request.observable().observeOn(this.environment.scheduler());
        }
        if (request instanceof ClusterRequest) {
            this.handleClusterRequest(request);
            return request.observable().observeOn(this.environment.scheduler());
        }
        boolean published = this.requestRingBuffer.tryPublishEvent(REQUEST_TRANSLATOR, request);
        if (!published) {
            request.observable().onError((Throwable)BACKPRESSURE_EXCEPTION);
        }
        return request.observable();
    }

    private void handleClusterRequest(final CouchbaseRequest request) {
        if (request instanceof SeedNodesRequest) {
            boolean success = this.configProvider.seedHosts(((SeedNodesRequest)request).nodes(), true);
            ResponseStatus status = success ? ResponseStatus.SUCCESS : ResponseStatus.FAILURE;
            request.observable().onNext((Object)new SeedNodesResponse(status));
            request.observable().onCompleted();
        } else if (request instanceof OpenBucketRequest) {
            this.configProvider.openBucket(request.bucket(), request.password()).flatMap((Func1)new Func1<ClusterConfig, Observable<ClusterConfig>>(){

                public Observable<ClusterConfig> call(ClusterConfig clusterConfig) {
                    return CouchbaseCore.this.requestHandler.reconfigure(clusterConfig);
                }
            }).map((Func1)new Func1<ClusterConfig, OpenBucketResponse>(){

                public OpenBucketResponse call(ClusterConfig clusterConfig) {
                    if (clusterConfig.hasBucket(request.bucket())) {
                        return new OpenBucketResponse(ResponseStatus.SUCCESS);
                    }
                    throw new CouchbaseException("Could not open bucket.");
                }
            }).subscribe(request.observable());
        } else if (request instanceof CloseBucketRequest) {
            this.configProvider.closeBucket(request.bucket()).flatMap((Func1)new Func1<ClusterConfig, Observable<ClusterConfig>>(){

                public Observable<ClusterConfig> call(ClusterConfig clusterConfig) {
                    return CouchbaseCore.this.requestHandler.reconfigure(clusterConfig);
                }
            }).map((Func1)new Func1<ClusterConfig, CloseBucketResponse>(){

                public CloseBucketResponse call(ClusterConfig clusterConfig) {
                    if (!clusterConfig.hasBucket(request.bucket())) {
                        return new CloseBucketResponse(ResponseStatus.SUCCESS);
                    }
                    throw new CouchbaseException("Could not close bucket.");
                }
            }).subscribe(request.observable());
        } else if (request instanceof DisconnectRequest) {
            this.configProvider.closeBuckets().flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

                public Observable<Boolean> call(Boolean done) {
                    return CouchbaseCore.this.sharedEnvironment ? Observable.just((Object)true) : CouchbaseCore.this.environment.shutdownAsync();
                }
            }).map((Func1)new Func1<Boolean, Boolean>(){

                public Boolean call(Boolean success) {
                    CouchbaseCore.this.requestDisruptor.shutdown();
                    CouchbaseCore.this.responseDisruptor.shutdown();
                    CouchbaseCore.this.disruptorExecutor.shutdownNow();
                    return success;
                }
            }).map((Func1)new Func1<Boolean, DisconnectResponse>(){

                public DisconnectResponse call(Boolean success) {
                    return new DisconnectResponse(ResponseStatus.SUCCESS);
                }
            }).subscribe(request.observable());
        } else if (request instanceof GetClusterConfigRequest) {
            request.observable().onNext((Object)new GetClusterConfigResponse(this.configProvider.config(), ResponseStatus.SUCCESS));
            request.observable().onCompleted();
        }
    }

    private void handleInternalRequest(final CouchbaseRequest request) {
        if (request instanceof GetConfigProviderRequest) {
            request.observable().onNext((Object)new GetConfigProviderResponse(this.configProvider));
            request.observable().onCompleted();
        } else if (request instanceof AddNodeRequest) {
            this.requestHandler.addNode(((AddNodeRequest)request).hostname()).map((Func1)new Func1<LifecycleState, AddNodeResponse>(){

                public AddNodeResponse call(LifecycleState state) {
                    return new AddNodeResponse(ResponseStatus.SUCCESS, ((AddNodeRequest)request).hostname());
                }
            }).subscribe(request.observable());
        } else if (request instanceof RemoveNodeRequest) {
            this.requestHandler.removeNode(((RemoveNodeRequest)request).hostname()).map((Func1)new Func1<LifecycleState, RemoveNodeResponse>(){

                public RemoveNodeResponse call(LifecycleState state) {
                    return new RemoveNodeResponse(ResponseStatus.SUCCESS);
                }
            }).subscribe(request.observable());
        } else if (request instanceof AddServiceRequest) {
            this.requestHandler.addService((AddServiceRequest)request).map((Func1)new Func1<Service, AddServiceResponse>(){

                public AddServiceResponse call(Service service) {
                    return new AddServiceResponse(ResponseStatus.SUCCESS, ((AddServiceRequest)request).hostname());
                }
            }).subscribe(request.observable());
        } else if (request instanceof RemoveServiceRequest) {
            this.requestHandler.removeService((RemoveServiceRequest)request).map((Func1)new Func1<Service, RemoveServiceResponse>(){

                public RemoveServiceResponse call(Service service) {
                    return new RemoveServiceResponse(ResponseStatus.SUCCESS);
                }
            }).subscribe(request.observable());
        } else {
            request.observable().onError((Throwable)new IllegalArgumentException("Unknown request " + request));
        }
    }

    static {
        BACKPRESSURE_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

