/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.gcube.common.couchdb.connector.HttpCouchClient;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceCouchDB
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceCouchDB.class);
    protected HttpCouchClient httpCouchClient;
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String USERNAME_PROPERTY_KEY = "username";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String DB_NAME = "dbName";

    public void close() throws Exception {
    }

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        String username = configuration.getProperty(USERNAME_PROPERTY_KEY);
        String password = configuration.getProperty(PASSWORD_PROPERTY_KEY);
        String dbName = configuration.getProperty(DB_NAME);
        this.httpCouchClient = new HttpCouchClient(url, dbName, username, password);
    }

    protected void createItem(JsonNode node, String id) throws Exception {
        this.httpCouchClient.put(node.toString(), id);
    }

    protected void reallyAccount(Record record) throws Exception {
        JsonNode node = PersistenceCouchDB.usageRecordToJsonNode(record);
        this.createItem(node, record.getId());
    }

    public static JsonNode usageRecordToJsonNode(Record record) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree((Object)record.getResourceProperties());
        return node;
    }

    protected static Record jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        Record record = RecordUtility.getRecord((Map)result);
        return record;
    }
}

