/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.container.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePublisher {
    private static final Logger log = LoggerFactory.getLogger(ProfilePublisher.class);
    private final ScopedPublisher publisher;
    private final ContainerContext context;

    public ProfilePublisher(ContainerContext context) {
        this.context = context;
        this.publisher = ProviderFactory.provider().publisherFor(context);
    }

    public void addTo(Collection<String> scopes) {
        Utils.notEmpty("scopes", scopes);
        log.info("publishing container in scopes {}", scopes);
        HostingNode profile = this.context.profile(HostingNode.class);
        try {
            profile = (HostingNode)this.publisher.create((Resource)profile, new ArrayList<String>(scopes));
            this.sharePublished(profile);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
    }

    public void update() {
        HostingNode profile = this.context.profile(HostingNode.class);
        log.info("publishing container in scopes {}", (Object)profile.scopes().asCollection());
        try {
            profile = (HostingNode)this.publisher.update((Resource)profile);
            this.sharePublished(profile);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
    }

    public void removeFrom(Collection<String> scopes) {
        HostingNode profile = this.context.profile(HostingNode.class);
        log.info("removing container from scopes {}", scopes);
        try {
            ArrayList<String> list = new ArrayList<String>(scopes);
            profile = (HostingNode)this.publisher.remove((Resource)profile, list);
            this.update();
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
    }

    private void sharePublished(HostingNode profile) {
        this.context.events().fire((Object)profile, new String[]{"published"});
    }
}

