/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.MoveToOperationResult;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

public abstract class AbstractTaskUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = -2208425042550641240L;
    @RequiredField
    @NotEmpty
    public static final String JOB_ID = "jobId";
    @RequiredField
    @NotEmpty
    public static final String REF_HOST = "refHost";
    @RequiredField
    @NotEmpty
    public static final String REF_VM = "refVM";
    @NotEmpty
    @DeprecatedWarning
    protected static final String DOMAIN = "domain";
    @RequiredField
    @ValidLong
    public static final String USAGE_START_TIME = "usageStartTime";
    @RequiredField
    @ValidLong
    public static final String USAGE_END_TIME = "usageEndTime";
    @MoveToOperationResult
    protected static final String USAGE_PHASE = "usagePhase";
    @ValidInteger
    public static final String INPUT_FILES_NUMBER = "inputFilesNumber";
    @ValidLong
    public static final String INPUT_FILES_SIZE = "inputFilesSize";
    @ValidInteger
    public static final String OUTPUT_FILES_NUMBER = "outputFilesNumber";
    @ValidLong
    public static final String OUTPUT_FILES_SIZE = "outputFilesSize";
    @ValidLong
    public static final String OVERALL_NETWORK_IN = "overallNetworkIn";
    @ValidLong
    public static final String OVERALL_NETWORK_OUT = "overallNetworkOut";
    @ValidInteger
    public static final String CORES = "cores";
    @ValidInteger
    public static final String PROCESSORS = "processors";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractTaskUsageRecord() {
    }

    public AbstractTaskUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    protected String giveMeUsageRecordType() {
        return AbstractTaskUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    public String getJobId() {
        return (String)this.resourceProperties.get(JOB_ID);
    }

    public void setJobId(String jobId) throws InvalidValueException {
        this.setResourceProperty(JOB_ID, (Serializable)((Object)jobId));
    }

    public String getRefHost() {
        return (String)this.resourceProperties.get(REF_HOST);
    }

    public void setRefHost(String refHost) throws InvalidValueException {
        this.setResourceProperty(REF_HOST, (Serializable)((Object)refHost));
    }

    public String getRefVM() {
        return (String)this.resourceProperties.get(REF_VM);
    }

    public void setRefVM(String refVM) throws InvalidValueException {
        this.setResourceProperty(REF_VM, (Serializable)((Object)refVM));
    }

    public Calendar getUsageStartTime() {
        long millis = (Long)this.resourceProperties.get(USAGE_START_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setUsageStartTime(Calendar usageStartTime) throws InvalidValueException {
        this.setResourceProperty(USAGE_START_TIME, Long.valueOf(usageStartTime.getTimeInMillis()));
    }

    public Calendar getUsageEndTime() {
        long millis = (Long)this.resourceProperties.get(USAGE_END_TIME);
        return this.timestampStringToCalendar(millis);
    }

    public void setUsageEndTime(Calendar usageEndTime) throws InvalidValueException {
        this.setResourceProperty(USAGE_END_TIME, Long.valueOf(usageEndTime.getTimeInMillis()));
    }

    public int getInputFilesNumber() {
        return (Integer)this.resourceProperties.get(INPUT_FILES_NUMBER);
    }

    public void setInputFilesNumber(int inputFilesNumber) throws InvalidValueException {
        this.setResourceProperty(INPUT_FILES_NUMBER, Integer.valueOf(inputFilesNumber));
    }

    public long getInputFilesSize() {
        return (Long)this.resourceProperties.get(INPUT_FILES_SIZE);
    }

    public void setInputFilesSize(long inputFilesSize) throws InvalidValueException {
        this.setResourceProperty(INPUT_FILES_SIZE, Long.valueOf(inputFilesSize));
    }

    public int getOutputFilesNumber() {
        return (Integer)this.resourceProperties.get(OUTPUT_FILES_NUMBER);
    }

    public void setOutputFilesNumber(int outputFilesNumber) throws InvalidValueException {
        this.setResourceProperty(OUTPUT_FILES_NUMBER, Integer.valueOf(outputFilesNumber));
    }

    public long getOutputFilesSize() {
        return (Long)this.resourceProperties.get(OUTPUT_FILES_SIZE);
    }

    public void setOutputFilesSize(long outputFilesSize) throws InvalidValueException {
        this.setResourceProperty(OUTPUT_FILES_SIZE, Long.valueOf(outputFilesSize));
    }

    public long getOverallNetworkIn() {
        return (Long)this.resourceProperties.get(OVERALL_NETWORK_IN);
    }

    public void setOverallNetworkIn(long overallNetworkIn) throws InvalidValueException {
        this.setResourceProperty(OVERALL_NETWORK_IN, Long.valueOf(overallNetworkIn));
    }

    public long getOverallNetworkOut() {
        return (Long)this.resourceProperties.get(OVERALL_NETWORK_OUT);
    }

    public void setOverallNetworkOut(long overallNetworkOut) throws InvalidValueException {
        this.setResourceProperty(OVERALL_NETWORK_OUT, Long.valueOf(overallNetworkOut));
    }

    public int getCores() {
        return (Integer)this.resourceProperties.get(CORES);
    }

    public void setCores(int cores) throws InvalidValueException {
        this.setResourceProperty(CORES, Integer.valueOf(cores));
    }

    public int getProcessors() {
        return (Integer)this.resourceProperties.get(PROCESSORS);
    }

    public void setProcessors(int processors) throws InvalidValueException {
        this.setResourceProperty(PROCESSORS, Integer.valueOf(processors));
    }

    public static enum USAGE_PHASE {
        completed,
        failed;

    }
}

