/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.container.lifecycle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.events.Observes;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.handlers.container.lifecycle.ProfileBuilder;
import org.gcube.smartgears.handlers.container.lifecycle.ProfilePublisher;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="profile-management")
public class ProfileManager
extends ContainerHandler {
    private static Logger log = LoggerFactory.getLogger(ProfileManager.class);
    private ContainerContext context;
    private ProfileBuilder builder;
    private ProfilePublisher publisher;
    private ScheduledFuture<?> periodicUpdates;

    @Override
    public void onStart(ContainerLifecycleEvent.Start e) {
        this.context = (ContainerContext)e.context();
        this.builder = new ProfileBuilder(this.context);
        this.publisher = new ProfilePublisher(this.context);
        HostingNode profile = this.loadOrCreateProfile();
        this.share(profile);
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation", "stop", "failure"})
            void onChanged(ContainerLifecycle lc) {
                HostingNode profile = ProfileManager.this.context.profile(HostingNode.class);
                profile.profile().description().status(((ContainerState)lc.state()).remoteForm());
                ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
            }

            @Observes(value={"published"}, kind=Observes.Kind.resilient)
            void storeAfterPublish(HostingNode profile) {
                ProfileManager.this.store(profile);
            }

            @Observes(value={"published"})
            void shareAfterPublish(HostingNode profile) {
                ProfileManager.this.share(profile);
            }

            @Observes(value={"changed"}, kind=Observes.Kind.critical)
            void publishAfterChange(HostingNode profile) {
                ProfileManager.this.publish(profile);
            }
        });
    }

    private HostingNode loadOrCreateProfile() {
        File file = this.context.configuration().persistence().file("ghn.xml");
        return file.exists() ? this.loadProfile(file) : this.createProfile();
    }

    private void share(HostingNode profile) {
        log.trace("sharing container profile");
        this.context.properties().add(new Property("ghn-profile", profile));
    }

    private HostingNode createProfile() {
        log.info("creating container profile");
        try {
            return this.builder.create();
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot create container profile", e);
        }
    }

    private HostingNode loadProfile(File file) {
        HostingNode hostingNode;
        log.info("loading container profile @ {}", (Object)file.getAbsolutePath());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            HostingNode node = (HostingNode)Resources.unmarshal(HostingNode.class, (InputStream)in);
            this.builder.update(node, true);
            hostingNode = node;
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException("cannot load container profile @ " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                Utils.closeSafely(in);
                throw throwable;
            }
        }
        Utils.closeSafely(in);
        return hostingNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(HostingNode profile) {
        File file = this.context.persistence().file("ghn.xml");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            log.trace("storing container profile @ {}", (Object)file.getAbsolutePath());
            Resources.marshal((Object)profile, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                log.error("cannot store container profile @ {}", (Object)file.getAbsolutePath(), (Object)e);
            }
            catch (Throwable throwable) {
                Utils.closeSafely(out);
                throw throwable;
            }
            Utils.closeSafely(out);
        }
        Utils.closeSafely(out);
    }

    private void publish(HostingNode profile) {
        ContainerConfiguration configuration = this.context.configuration();
        boolean firstPublication = profile.scopes().isEmpty();
        try {
            if (firstPublication) {
                this.publisher.addTo(configuration.startScopes());
            } else {
                this.publisher.update();
            }
        }
        catch (Exception e) {
            log.error("cannot publish container (see details)", (Throwable)e);
            this.store(profile);
        }
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){
            final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

            @Observes(value={"activation", "part_activation"}, kind=Observes.Kind.resilient)
            void startPeriodicUpdates(ContainerLifecycle ignore) {
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        HostingNode profile = ProfileManager.this.context.profile(HostingNode.class);
                        try {
                            ProfileManager.this.builder.update(profile, false);
                        }
                        catch (Exception e) {
                            log.error("cannot complete periodic update of container profile", (Throwable)e);
                        }
                        ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
                    }
                };
                ProfileManager.this.periodicUpdates = this.service.scheduleAtFixedRate(updateTask, 3L, ProfileManager.this.context.configuration().publicationFrequency(), TimeUnit.SECONDS);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (ProfileManager.this.periodicUpdates != null) {
                    log.trace("stopping periodic updates of container profile");
                }
                try {
                    ProfileManager.this.periodicUpdates.cancel(false);
                    this.service.shutdownNow();
                }
                catch (Exception e) {
                    log.warn("could not stop periodic updates of container profile", (Throwable)e);
                }
            }
        });
    }

    public String toString() {
        return "profile-management";
    }
}

