/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.util.LinkedList;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.AdvancedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;
import org.gcube.informationsystem.publisher.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdvancedPublisherCommonUtils {
    protected RegistryStubs registry;
    private static final Logger log = LoggerFactory.getLogger(AdvancedPublisher.class);

    public <T extends Resource> T forceRemove(T resource) {
        RegistryStub stub = null;
        this.registry = new RegistryStubs();
        String currentScope = ScopeProvider.instance.get();
        if (new ScopeBean(currentScope).is(ScopeBean.Type.VRE) || new ScopeBean(currentScope).is(ScopeBean.Type.VO)) {
            ScopeGroup scopes = resource.scopes();
            LinkedList<String> scopesToRemove = new LinkedList<String>();
            for (String scope : scopes) {
                log.debug(" check scope: " + scope);
                if (!scope.equals(currentScope)) continue;
                ScopeProvider.instance.set(scope);
                try {
                    stub = this.registry.getStubs();
                }
                catch (RegistryNotFoundException e) {
                    throw new IllegalArgumentException(e.getCause());
                }
                log.debug("remove scope " + scope);
                try {
                    stub.remove(resource.id(), resource.type().toString());
                }
                catch (ResourceDoesNotExistException e) {
                    // empty catch block
                }
                scopesToRemove.add(scope);
            }
            for (String scope : scopesToRemove) {
                ResourceMediator.removeScope(resource, scope);
            }
        } else {
            ScopeGroup scopes = resource.scopes();
            LinkedList<String> scopesToRemove = new LinkedList<String>();
            for (String scope : scopes) {
                log.debug(" check scope: " + scope);
                String voScope = null;
                if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
                    voScope = new ScopeBean(scope).enclosingScope().toString();
                }
                if (!scope.equals(currentScope) && !ValidationUtils.isChildScope(currentScope, scope) && (voScope == null || !ValidationUtils.isChildScope(currentScope, voScope))) continue;
                ScopeProvider.instance.set(scope);
                try {
                    stub = this.registry.getStubs();
                }
                catch (RegistryNotFoundException e) {
                    throw new IllegalArgumentException(e.getCause());
                }
                log.debug("remove scope " + scope);
                try {
                    stub.remove(resource.id(), resource.type().toString());
                }
                catch (ResourceDoesNotExistException e) {
                    // empty catch block
                }
                scopesToRemove.add(scope);
            }
            for (String scope : scopesToRemove) {
                ResourceMediator.removeScope(resource, scope);
            }
        }
        ScopeProvider.instance.set(currentScope);
        return resource;
    }
}

