/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationExtensions;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.configuration.application.DefaultApplicationConfiguration;
import org.gcube.smartgears.extensions.ApplicationExtension;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.lifecycle.ApplicationProfileManager;
import org.gcube.smartgears.handlers.application.request.RequestAccounting;
import org.gcube.smartgears.handlers.application.request.RequestValidator;
import org.gcube.smartgears.utils.Utils;

public class ApplicationConfigurationBinder {
    public ApplicationConfiguration bind(InputStream stream) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{DefaultApplicationConfiguration.class});
            ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)ctx.createUnmarshaller().unmarshal(stream);
            return applicationConfiguration;
        }
        catch (JAXBException e) {
            throw new RuntimeException("invalid service configuration", e);
        }
        finally {
            Utils.closeSafely(stream);
        }
    }

    public ApplicationHandlers bindHandlers(ClassLoader classLoader) {
        LinkedList<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();
        requestHandlers.add(new RequestValidator());
        requestHandlers.add(new RequestAccounting());
        LinkedList<ApplicationLifecycleHandler> lifecycleHandlers = new LinkedList<ApplicationLifecycleHandler>();
        lifecycleHandlers.add(new ApplicationProfileManager());
        return new ApplicationHandlers(lifecycleHandlers, requestHandlers);
    }

    public ApplicationExtensions bindExtensions(InputStream stream) {
        Set<Class<?>> classes = this.scanForExtensions();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
            ApplicationExtensions applicationExtensions = (ApplicationExtensions)ctx.createUnmarshaller().unmarshal(stream);
            return applicationExtensions;
        }
        catch (JAXBException e) {
            throw Utils.unchecked(e);
        }
        finally {
            Utils.closeSafely(stream);
        }
    }

    private Set<Class<?>> scanForExtensions() throws RuntimeException {
        ServiceLoader<ApplicationExtension> handlerLoader = ServiceLoader.load(ApplicationExtension.class);
        HashSet scanned = new HashSet();
        for (ApplicationExtension handler : handlerLoader) {
            Class<?> handlerClass = handler.getClass();
            if (handlerClass.isInterface() || handlerClass.getModifiers() == 1024) continue;
            scanned.add(handlerClass);
        }
        scanned.add(ApplicationExtensions.class);
        return scanned;
    }

    public void scanForApplicationHandlers(ClassLoader currentClassLoader) {
    }
}

