/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import java.net.URL;
import java.util.List;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.model.TokenIntrospectionResponse;
import org.gcube.common.keycloak.model.TokenResponse;

public interface KeycloakClient {
    public static final String PROD_ROOT_SCOPE = "/d4science.research-infrastructures.eu";
    public static final String OPEN_ID_URI_PATH = "protocol/openid-connect";
    public static final String TOKEN_URI_PATH = "token";
    public static final String TOKEN_INTROSPECT_URI_PATH = "introspect";
    public static final String DEFAULT_REALM = "d4science";

    public URL getRealmBaseURL(String var1) throws KeycloakClientException;

    public URL getRealmBaseURL(String var1, String var2) throws KeycloakClientException;

    public URL getTokenEndpointURL(URL var1) throws KeycloakClientException;

    public URL getIntrospectionEndpointURL(URL var1) throws KeycloakClientException;

    public URL computeIntrospectionEndpointURL(URL var1) throws KeycloakClientException;

    public TokenResponse queryOIDCToken(String var1, String var2, String var3) throws KeycloakClientException;

    public TokenResponse queryOIDCToken(URL var1, String var2, String var3) throws KeycloakClientException;

    public TokenResponse queryOIDCToken(String var1, String var2) throws KeycloakClientException;

    public TokenResponse queryOIDCToken(URL var1, String var2) throws KeycloakClientException;

    public TokenResponse queryUMAToken(String var1, String var2, String var3, List<String> var4) throws KeycloakClientException;

    public TokenResponse queryUMAToken(URL var1, String var2, String var3, List<String> var4) throws KeycloakClientException;

    public TokenResponse queryUMAToken(String var1, TokenResponse var2, String var3, List<String> var4) throws KeycloakClientException;

    public TokenResponse queryUMAToken(URL var1, TokenResponse var2, String var3, List<String> var4) throws KeycloakClientException;

    public TokenResponse queryUMAToken(String var1, String var2, String var3, String var4, List<String> var5) throws KeycloakClientException;

    public TokenResponse queryUMAToken(URL var1, String var2, String var3, String var4, List<String> var5) throws KeycloakClientException;

    public TokenResponse refreshToken(String var1, TokenResponse var2) throws KeycloakClientException;

    public TokenResponse refreshToken(URL var1, TokenResponse var2) throws KeycloakClientException;

    public TokenResponse refreshToken(String var1, String var2, String var3, TokenResponse var4) throws KeycloakClientException;

    public TokenResponse refreshToken(URL var1, String var2, String var3, TokenResponse var4) throws KeycloakClientException;

    public TokenResponse refreshToken(String var1, String var2, String var3, String var4) throws KeycloakClientException;

    public TokenResponse refreshToken(URL var1, String var2, String var3, String var4) throws KeycloakClientException;

    public TokenIntrospectionResponse introspectAccessToken(String var1, String var2, String var3, String var4) throws KeycloakClientException;

    public TokenIntrospectionResponse introspectAccessToken(URL var1, String var2, String var3, String var4) throws KeycloakClientException;

    public boolean isAccessTokenVerified(String var1, String var2, String var3, String var4) throws KeycloakClientException;

    public boolean isAccessTokenVerified(URL var1, String var2, String var3, String var4) throws KeycloakClientException;
}

