/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security;

import java.util.concurrent.Callable;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedTasks {
    private static Logger logger = LoggerFactory.getLogger(AuthorizedTasks.class);

    public static <V> Callable<V> bind(final Callable<V> task) {
        final Secret secret = SecretManagerProvider.instance.get();
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                SecretManagerProvider.instance.set(secret);
                try {
                    logger.info("setting on authorized task context {} ", (Object)secret.getContext());
                    Object v = task.call();
                    return v;
                }
                finally {
                    SecretManagerProvider.instance.reset();
                }
            }
        };
    }

    public static <V> Runnable bind(final Runnable task) {
        final Secret secret = SecretManagerProvider.instance.get();
        return new Runnable(){

            @Override
            public void run() {
                SecretManagerProvider.instance.set(secret);
                try {
                    logger.info("setting on authorized task context {} ", (Object)secret.getContext());
                    task.run();
                }
                finally {
                    SecretManagerProvider.instance.reset();
                }
            }
        };
    }

    public static void executeSafely(Runnable task, Secret secret) {
        Secret previousSecret = SecretManagerProvider.instance.get();
        try {
            SecretManagerProvider.instance.set(secret);
            task.run();
        }
        finally {
            SecretManagerProvider.instance.set(previousSecret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeSafely(Callable<T> task, Secret secret) throws Throwable {
        Secret previousSecret = SecretManagerProvider.instance.get();
        try {
            SecretManagerProvider.instance.set(secret);
            T t = task.call();
            return t;
        }
        finally {
            SecretManagerProvider.instance.set(previousSecret);
        }
    }
}

