/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.fw.queries;

import java.net.URI;
import java.util.List;
import org.gcube.common.clients.GCubeEndpoint;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class StatefulQuery
implements org.gcube.common.clients.queries.Query<GCubeEndpoint> {
    private static String secondaryTypeFromat = "$resource/Profile/SecondaryType/text() eq '%1s'";
    private static String classFormat = "$resource/Profile/Body/StatefulResource/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/Body/StatefulResource/ServiceName/text() eq '%1s'";
    private static DiscoveryClient<GCubeEndpoint> client = ICFactory.clientFor(GCubeEndpoint.class);
    private final SimpleQuery query;

    public StatefulQuery(Plugin<?, ?> plugin) {
        this.query = ICFactory.queryFor(GenericResource.class).addCondition(String.format(secondaryTypeFromat, "StatefulResource")).addCondition(String.format(classFormat, plugin.serviceClass())).addCondition(String.format(nameFormat, plugin.serviceName())).setResult("<endpoint><key>{$resource/Profile/Body/StatefulResource/Key/text()}</key><address>{$resource/Profile/Body/StatefulResource/ServiceAddress/text()}</address></endpoint>");
    }

    public StatefulQuery addVariable(String name, String range) {
        this.query.addVariable(name, range);
        return this;
    }

    public StatefulQuery addCondition(String condition) {
        this.query.addCondition(condition);
        return this;
    }

    public StatefulQuery addNamespace(String prefix, URI uri) {
        this.query.addNamespace(prefix, uri);
        return this;
    }

    public List<GCubeEndpoint> fire() throws org.gcube.common.clients.exceptions.DiscoveryException {
        List instances = null;
        try {
            instances = client.submit((Query)this.query);
        }
        catch (DiscoveryException ex) {
            throw new org.gcube.common.clients.exceptions.DiscoveryException((Throwable)ex);
        }
        return instances;
    }

    public String toString() {
        return this.query.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatefulQuery other = (StatefulQuery)obj;
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }
}

