/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.IsValid;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.configuration.application.Include;
import org.gcube.smartgears.persistence.LocalPersistence;
import org.gcube.smartgears.persistence.PersistenceWriter;

@XmlRootElement(name="application")
public class DefaultApplicationConfiguration
implements ApplicationConfiguration {
    String context;
    @XmlAttribute(name="proxable")
    private boolean proxable = true;
    @XmlElement(name="name", required=true)
    @NotNull
    String name;
    @XmlElement(name="group", required=true)
    @NotNull
    String group;
    @XmlElement(name="version", required=true)
    @NotNull
    String version;
    @XmlElement(name="description")
    String description = "";
    @XmlElementRef
    Set<Exclude> excludes = new LinkedHashSet<Exclude>();
    @XmlElementRef
    Set<Include> includes = new LinkedHashSet<Include>();
    @XmlElementRef(type=LocalPersistence.class)
    @NotNull
    @IsValid
    private PersistenceWriter persistenceManager;
    @IsValid
    ProxyAddress proxyAddress;

    @Override
    public Set<Exclude> excludes() {
        return this.excludes;
    }

    @Override
    public Set<Include> includes() {
        return this.includes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String context() {
        return this.context;
    }

    @Override
    public ApplicationConfiguration context(String context) {
        this.context = context;
        return this;
    }

    @Override
    public ApplicationConfiguration excludes(Exclude ... excludes) {
        this.excludes = new HashSet<Exclude>(Arrays.asList(excludes));
        return this;
    }

    @Override
    public ApplicationConfiguration includes(Include ... includes) {
        this.includes = new HashSet<Include>(Arrays.asList(includes));
        return this;
    }

    @Override
    public ApplicationConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String serviceClass() {
        return this.group;
    }

    @Override
    public ApplicationConfiguration serviceClass(String group) {
        this.group = group;
        return this;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public ApplicationConfiguration version(String version) {
        this.version = version;
        return this;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ApplicationConfiguration description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean proxable() {
        return this.proxable;
    }

    @Override
    public ProxyAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Override
    public ApplicationConfiguration proxyAddress(ProxyAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        return this;
    }

    @Override
    public PersistenceWriter persistence() {
        return this.persistenceManager;
    }

    @Override
    public ApplicationConfiguration persistence(PersistenceWriter manager) {
        this.persistenceManager = manager;
        return this;
    }

    @Override
    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!this.excludes().isEmpty() && !this.includes().isEmpty()) {
            msgs.add("exclude tags and includes tags are mutually exclusive");
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + msgs);
        }
    }

    @Override
    public void merge(ApplicationConfiguration config) {
        if (config.persistence() != null) {
            this.persistence(config.persistence());
        }
    }
}

