/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.utils.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeName {
    private static Logger logger = LoggerFactory.getLogger(PropertyTypeName.class);
    protected static final Map<Class<?>, BaseType> BASE_PROPERTY_TYPES_BY_CLASS = new HashMap();
    protected BaseType baseType;
    protected boolean genericType;
    protected BaseType genericBaseType;
    protected String genericClassName;

    public static BaseType getBaseTypeByClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        BaseType type = BASE_PROPERTY_TYPES_BY_CLASS.get(clazz);
        if (type == null) {
            for (Class<?> c : BASE_PROPERTY_TYPES_BY_CLASS.keySet()) {
                if (!c.isAssignableFrom(clazz)) continue;
                type = BASE_PROPERTY_TYPES_BY_CLASS.get(c);
            }
        }
        return type;
    }

    public PropertyTypeName(String type) {
        this.setType(type);
    }

    public PropertyTypeName(Method method) {
        this.baseType = null;
        this.genericType = false;
        this.genericBaseType = null;
        this.genericClassName = null;
        Class<?> clz = method.getReturnType();
        logger.trace("Return Type for method {} is {}", (Object)method, clz);
        this.baseType = PropertyTypeName.getBaseTypeByClass(clz);
        if (this.baseType == BaseType.PROPERTY && clz != PropertyElement.class) {
            Class<?> type = clz;
            this.genericType = true;
            this.genericClassName = TypeMapper.getType(type);
            return;
        }
        if (this.baseType != null) {
            if (this.baseType.ordinal() > BaseType.PROPERTY.ordinal()) {
                this.genericType = true;
                Type genericReturnType = method.getGenericReturnType();
                logger.trace("Generic Return Type for method {} is {}", (Object)method, (Object)genericReturnType);
                Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                Type genericType = null;
                for (Type t : actualTypeArguments) {
                    logger.trace("Generic Return Type {} for method {} - Actual Type Argument : {}", new Object[]{genericReturnType, method, t});
                    genericType = t;
                }
                this.genericBaseType = PropertyTypeName.getBaseTypeByClass((Class)genericType);
                if (this.genericBaseType != null && this.genericBaseType.ordinal() > BaseType.PROPERTY.ordinal()) {
                    throw new IllegalArgumentException("The generic of a " + this.baseType.toString() + " cannot be a Set, a List or a Map.");
                }
                if (this.genericBaseType == BaseType.PROPERTY) {
                    Class genericElementType = (Class)genericType;
                    this.genericClassName = TypeMapper.getType(genericElementType);
                }
            }
        } else {
            throw new IllegalArgumentException("Type " + clz.getSimpleName() + " not supported as property type");
        }
    }

    public void setType(String type) {
        int indexOfMinor = type.indexOf("<");
        this.genericType = indexOfMinor != -1;
        if (!this.genericType) {
            try {
                this.baseType = BaseType.getBaseTypeFromString(type);
                if (this.baseType.ordinal() > BaseType.PROPERTY.ordinal()) {
                    throw new IllegalArgumentException("Set, List and Map must specify a generic type, e.g. Set<Property>, List<Integer>.");
                }
                return;
            }
            catch (IllegalArgumentException e) {
                this.baseType = BaseType.PROPERTY;
                this.genericType = true;
                this.genericClassName = type;
                return;
            }
        }
        String cleanTypeFromGeneric = type.substring(0, indexOfMinor);
        this.baseType = BaseType.getBaseTypeFromString(cleanTypeFromGeneric);
        if (this.genericType && this.baseType.ordinal() <= BaseType.PROPERTY.ordinal()) {
            throw new IllegalArgumentException("Only Set, List and Map can be generic. Map can only have String as Key");
        }
        String generic = type.substring(indexOfMinor + 1, type.length() - 1);
        if (this.baseType == BaseType.MAP) {
            int l = generic.length();
            generic = generic.replace(BaseType.STRING.toString() + ",", "");
            if (l != BaseType.STRING.stringValue.length() + 1 + generic.length()) {
                throw new IllegalArgumentException("A Map can only has String as key e.g. Map<String,Integer>");
            }
        }
        try {
            this.genericBaseType = BaseType.getBaseTypeFromString(generic);
        }
        catch (IllegalArgumentException e) {
            this.genericBaseType = BaseType.PROPERTY;
            this.genericClassName = generic;
        }
        if (this.genericBaseType != null && this.genericBaseType.ordinal() > BaseType.PROPERTY.ordinal()) {
            throw new IllegalArgumentException("The generic of a " + this.baseType.toString() + " cannot be a Set, a List or a Map.");
        }
    }

    public String getType() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.baseType) {
            case PROPERTY: {
                if (this.genericClassName != null) {
                    stringBuffer.append(this.genericClassName);
                    break;
                }
                stringBuffer.append(this.baseType.toString());
                break;
            }
            case SET: 
            case LIST: 
            case MAP: {
                stringBuffer.append(this.baseType.toString());
                stringBuffer.append("<");
                if (this.baseType == BaseType.MAP) {
                    stringBuffer.append(BaseType.STRING.toString());
                    stringBuffer.append(",");
                }
                if (this.genericClassName != null) {
                    stringBuffer.append(this.genericClassName);
                } else {
                    stringBuffer.append(this.genericBaseType.toString());
                }
                stringBuffer.append(">");
                break;
            }
            default: {
                stringBuffer.append(this.baseType.toString());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getType();
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public boolean isGenericType() {
        return this.genericType;
    }

    public BaseType getGenericBaseType() {
        return this.genericBaseType;
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseType, this.genericBaseType, this.genericClassName, this.genericType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyTypeName other = (PropertyTypeName)obj;
        return this.baseType == other.baseType && this.genericBaseType == other.genericBaseType && Objects.equals(this.genericClassName, other.genericClassName) && this.genericType == other.genericType;
    }

    static {
        BASE_PROPERTY_TYPES_BY_CLASS.put(Boolean.TYPE, BaseType.BOOLEAN);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Boolean.class, BaseType.BOOLEAN);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Integer.TYPE, BaseType.INTEGER);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Integer.class, BaseType.INTEGER);
        BASE_PROPERTY_TYPES_BY_CLASS.put(BigInteger.class, BaseType.INTEGER);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Short.TYPE, BaseType.SHORT);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Short.class, BaseType.SHORT);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Long.TYPE, BaseType.LONG);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Long.class, BaseType.LONG);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Float.TYPE, BaseType.FLOAT);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Float.class, BaseType.FLOAT);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Double.TYPE, BaseType.DOUBLE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Double.class, BaseType.DOUBLE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Date.class, BaseType.DATE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Calendar.class, BaseType.DATE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(String.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Character.TYPE, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Character.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Byte.TYPE, BaseType.BYTE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Byte.class, BaseType.BYTE);
        BASE_PROPERTY_TYPES_BY_CLASS.put(byte[].class, BaseType.BINARY);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Byte[].class, BaseType.BINARY);
        BASE_PROPERTY_TYPES_BY_CLASS.put(PropertyElement.class, BaseType.PROPERTY);
        BASE_PROPERTY_TYPES_BY_CLASS.put(List.class, BaseType.LIST);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Set.class, BaseType.SET);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Map.class, BaseType.MAP);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Enum.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(URI.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(URL.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(UUID.class, BaseType.STRING);
        BASE_PROPERTY_TYPES_BY_CLASS.put(Version.class, BaseType.STRING);
    }

    public static enum BaseType {
        BOOLEAN("Boolean"),
        INTEGER("Integer"),
        SHORT("Short"),
        LONG("Long"),
        FLOAT("Float"),
        DOUBLE("Double"),
        DATE("Date"),
        STRING("String"),
        BINARY("Binary"),
        BYTE("Byte"),
        PROPERTY("Property"),
        LIST("List"),
        SET("Set"),
        MAP("Map");

        private final String stringValue;
        protected static final Map<String, BaseType> map;

        private BaseType(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }

        public static BaseType getBaseTypeFromString(String type) {
            BaseType baseType = map.get(type);
            if (baseType == null) {
                throw new IllegalArgumentException("No BaseType having '" + type + "' as string value. Allowed values are " + map.keySet());
            }
            return baseType;
        }

        static {
            map = new HashMap<String, BaseType>();
            for (BaseType baseType : BaseType.values()) {
                map.put(baseType.stringValue, baseType);
            }
        }
    }
}

