/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher.utils;

import java.net.URI;
import java.util.List;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.informationsystem.publisher.cache.RegistryCache;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.stubs.registry.CollectorStubs;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryConstants;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.impl.DelegateClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICClient;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryStubs {
    private RegistryCache cache = new RegistryCache(10);
    private List<URI> endpoints;
    private static final Logger log = LoggerFactory.getLogger(RegistryStubs.class);
    private static final String XMLSTOREACCESS_SERVICE = "XMLStoreService";

    public List<URI> getEndPoints() {
        String scope = ScopeProvider.instance.get();
        this.endpoints = this.cache.get(scope);
        if (this.endpoints == null) {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            ResultParser<URI> uriParser = new ResultParser<URI>(){

                public URI parse(String result) throws Exception {
                    return new URI(result.replaceAll("\n", ""));
                }
            };
            DelegateClient client = new DelegateClient((ResultParser)uriParser, (DiscoveryClient)new ICClient());
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + RegistryConstants.service_class + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + RegistryConstants.service_name + "'").setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint[string(@EntryName) eq '" + RegistryConstants.service_entrypoint + "']/string()");
            this.endpoints = client.submit((Query)query);
            if (this.endpoints.size() == 0) {
                throw new IllegalArgumentException("No registry endpoint found");
            }
            this.cache.put(scope, this.endpoints);
        }
        return this.endpoints;
    }

    public RegistryStub getStubs() throws RegistryNotFoundException {
        ServiceMap serviceMap = ServiceMap.instance;
        if (serviceMap != null && serviceMap.version().equals("2.0.0")) {
            try {
                Class<?> localClientclass = Class.forName("org.gcube.informationsystem.collector.client.LocalPublisherClient", true, Thread.currentThread().getContextClassLoader());
                log.info("using LocalPublisherClient, information collector specific publisher");
                return (RegistryStub)localClientclass.newInstance();
            }
            catch (Exception e) {
                String endpoint = serviceMap.endpoint(XMLSTOREACCESS_SERVICE);
                log.info("using REST COLLECTOR");
                return new CollectorStubs(endpoint);
            }
        }
        URI endpoint = this.getEndPoints().get(0);
        log.info("getting REGISTRY STUBS stubs from endpoint: {}", (Object)endpoint);
        return (RegistryStub)StubFactory.stubFor(RegistryConstants.registry).at(endpoint);
    }

    public RegistryStub getStubs(URI endpoint) throws RegistryNotFoundException {
        log.debug("get stubs from endpoint: {}", (Object)endpoint);
        return (RegistryStub)StubFactory.stubFor(RegistryConstants.registry).at(endpoint);
    }
}

