/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.application.ApplicationExtensions;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.extensions.ApplicationExtension;
import org.gcube.smartgears.extensions.RequestExceptionBarrier;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.ApplicationPipeline;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.managers.RequestManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationManager {
    private static Logger log = LoggerFactory.getLogger(ApplicationManager.class);
    private ApplicationPipeline<ApplicationLifecycleHandler> lifecyclePipeline;
    private ApplicationContext context;

    public ApplicationContext start(ContainerContext container, ServletContext application) {
        try {
            this.context = ProviderFactory.provider().contextFor(container, application);
            this.context.configuration().validate();
            this.shareContextWith(application);
            this.registerObservers();
            ApplicationHandlers handlers = ProviderFactory.provider().handlersFor(this.context);
            handlers.validate();
            ApplicationExtensions extensions = ProviderFactory.provider().extensionsFor(this.context);
            extensions.validate();
            List<ApplicationLifecycleHandler> lifecycleHandlers = handlers.lifecycleHandlers();
            List<RequestHandler> requestHandlers = handlers.requestHandlers();
            log.trace("managing {} lifecycle with {}", (Object)this.context.name(), lifecycleHandlers);
            log.trace("managing {} requests with {}", (Object)this.context.name(), requestHandlers);
            log.trace("extending {} API with {}", (Object)this.context.name(), (Object)extensions);
            this.register(extensions);
            this.register(requestHandlers);
            this.start(lifecycleHandlers);
            this.context.configuration().context(application.getContextPath());
            this.context.lifecycle().moveTo(ApplicationState.active);
            return this.context;
        }
        catch (RuntimeException e) {
            if (this.context != null) {
                this.context.lifecycle().moveTo(ApplicationState.failed);
            }
            throw e;
        }
    }

    public void stop() {
        if (this.context == null) {
            return;
        }
        log.info("stopping {} management", (Object)this.context.name());
        try {
            this.context.lifecycle().tryMoveTo(ApplicationState.stopped);
            this.stopLifecycleHandlers();
            log.info("stopping application events for {}", (Object)this.context.name());
            this.context.events().stop();
        }
        catch (Exception e) {
            log.warn("cannot stop {} management (see cause)", (Object)this.context.name(), (Object)e);
        }
    }

    private void register(List<RequestHandler> rqHandlers) {
        ServletContext app = this.context.application();
        ApplicationPipeline<RequestHandler> rqPipelineTemplate = new ApplicationPipeline<RequestHandler>(rqHandlers);
        Collection servlets = app.getServletRegistrations().values();
        for (ServletRegistration servlet : servlets) {
            String name = servlet.getName();
            if (name.equals("default") || name.equals("jsp")) continue;
            for (String mapping : servlet.getMappings()) {
                RequestManager requestFilter = new RequestManager(this.context, name, rqPipelineTemplate);
                FilterRegistration.Dynamic filter = app.addFilter(name + "-filter", (Filter)requestFilter);
                filter.addMappingForUrlPatterns(null, false, new String[]{mapping});
            }
        }
    }

    private void register(ApplicationExtensions extensions) {
        ServletContext application = this.context.application();
        for (ApplicationExtension extension : extensions.extensions()) {
            try {
                extension.init(this.context);
                this.context.configuration().excludes().addAll(extension.excludes());
                String mapping = "/gcube" + extension.mapping();
                application.addServlet(this.context.configuration().name() + "-" + extension.name(), (Servlet)extension).addMapping(new String[]{mapping});
                RequestExceptionBarrier barrier = new RequestExceptionBarrier();
                FilterRegistration.Dynamic filter = application.addFilter("exception-barrier", (Filter)barrier);
                filter.addMappingForUrlPatterns(null, false, new String[]{mapping});
                log.info("registered API extension {} @ {}", (Object)extension.name(), (Object)mapping);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot register API extension " + extension.name(), e);
            }
        }
    }

    private void start(List<ApplicationLifecycleHandler> handlers) {
        try {
            this.lifecyclePipeline = new ApplicationPipeline<ApplicationLifecycleHandler>(handlers);
            this.lifecyclePipeline.forward(new ApplicationLifecycleEvent.Start(this.context));
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(ApplicationState.failed);
            throw e;
        }
    }

    private void stopLifecycleHandlers() {
        if (this.lifecyclePipeline == null) {
            return;
        }
        ApplicationPipeline<ApplicationLifecycleHandler> returnPipeline = this.lifecyclePipeline.reverse();
        returnPipeline.forward(new ApplicationLifecycleEvent.Stop(this.context));
    }

    private void registerObservers() {
        this.context.container().events().subscribe(new Object(){

            @Observes(value={"stop"}, kind=Observes.Kind.critical)
            void onStopOf(ContainerLifecycle ignore) {
                if (!ApplicationManager.this.context.lifecycle().tryMoveTo(ApplicationState.stopped)) {
                    log.warn("cannot stop {} after container has stopped", (Object)ApplicationManager.this.context.name());
                }
            }
        });
        this.context.application().addListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
            }

            public void contextDestroyed(ServletContextEvent sce) {
                try {
                    log.info("stopping {} on undeployment|shutdown !!!", (Object)ApplicationManager.this.context.name());
                    log.info("source event from " + sce.getSource());
                    new Throwable().printStackTrace();
                    ApplicationManager.this.stop();
                    log.info("suspending undeployment|shutdow to allow {} to stop gracefully !!!", (Object)ApplicationManager.this.context.name());
                    TimeUnit.SECONDS.sleep(3L);
                    log.info("resuming undeployment|shutdow after stopping {}", (Object)ApplicationManager.this.context.name());
                }
                catch (InterruptedException e) {
                    log.warn(ApplicationManager.this.context.name() + " cannot gracefully stop on undeployment|shutdow", (Throwable)e);
                }
            }
        });
    }

    private void shareContextWith(ServletContext application) {
        application.setAttribute("gcube-application-context", (Object)this.context);
    }
}

