/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.managers.ApplicationManager;
import org.gcube.smartgears.managers.ContainerManager;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
implements ServletContainerInitializer {
    private static Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private static boolean smartgearsHasStarted = false;
    private static boolean containerHasFailed = false;
    private static ContainerManager manager;
    private static ContainerContext context;

    public Bootstrap() {
        if (smartgearsHasStarted) {
            return;
        }
        smartgearsHasStarted = true;
        this.initialiseContainer();
    }

    public void onStartup(Set<Class<?>> c, ServletContext application) throws ServletException {
        log.info("me here : " + application.getContextPath());
        ApplicationManager appManager = new ApplicationManager();
        if (this.isResource(application)) {
            try {
                this.startContainerIfItHasntAlreadyFailed();
                log.info("starting management of application @ {}", (Object)application.getContextPath());
                ApplicationContext app = appManager.start(context, application);
                manager.manage(app);
            }
            catch (Throwable t) {
                appManager.stop();
                throw new ServletException("cannot manage application @ " + application.getContextPath() + " (see cause)", t);
            }
        }
    }

    private void initialiseContainer() {
        try {
            log.trace("smartgears is starting");
            context = ProviderFactory.provider().containerContext();
            context.configuration().validate();
        }
        catch (RuntimeException e) {
            containerHasFailed = true;
            log.error("cannot start smartgears", (Throwable)e);
        }
    }

    private void startContainerIfItHasntAlreadyFailed() {
        if (containerHasFailed) {
            throw new IllegalStateException("container is not managed due to previous failure");
        }
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ContainerManager.class.getClassLoader());
            manager = ContainerManager.instance;
            context = manager.start(context);
        }
        catch (RuntimeException e) {
            containerHasFailed = true;
            throw new IllegalStateException("cannot manage container", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private boolean isResource(ServletContext application) {
        return !containerHasFailed && context.configuration().app(application.getContextPath()) != null || application.getResourceAsStream("/WEB-INF/gcube-app.xml") != null;
    }
}

