/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationPipeline;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.handlers.application.request.RequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestManager
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestManager.class);
    private final ApplicationContext context;
    private final String servlet;
    private final ApplicationPipeline<RequestHandler> pipeline;

    public RequestManager(ApplicationContext context, String servletName, ApplicationPipeline<RequestHandler> pipeline) {
        this.context = context;
        this.servlet = servletName;
        this.pipeline = pipeline;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        if (this.shouldExcludeRequest(httprequest)) {
            chain.doFilter(request, response);
        } else {
            DefaultApplicationContext ctx = new DefaultApplicationContext(this.context);
            RequestEvent event = new RequestEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                this.pipeline.forward(event);
            }
            catch (Throwable t) {
                this.handleError(httprequest, httpresponse, t);
                return;
            }
            chain.doFilter(request, response);
            ResponseEvent responseEvent = new ResponseEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                this.pipeline.reverse().forward(responseEvent);
            }
            catch (Throwable t) {
                this.handleError(httprequest, httpresponse, t);
                return;
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            for (RequestHandler handler : this.pipeline.handlers()) {
                handler.start(this.context);
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void destroy() {
        for (RequestHandler handler : this.pipeline.handlers()) {
            try {
                handler.stop();
            }
            catch (Throwable t) {
                log.error("cannot terminate handler {} for application {} ", (Object)handler, (Object)this.context.name());
            }
        }
    }

    private boolean shouldExcludeRequest(HttpServletRequest request) {
        String query = request.getQueryString();
        if ("wsdl".equals(query)) {
            return true;
        }
        String path = request.getPathInfo();
        for (String exclude : this.context.configuration().excludes()) {
            if (!"*".equals(exclude) && (!exclude.endsWith("*") || !path.startsWith(exclude.substring(0, exclude.length() - 2))) && !exclude.equals(path)) continue;
            return true;
        }
        return false;
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
        RequestError error;
        RequestError requestError = error = t instanceof RequestException ? ((RequestException)RequestException.class.cast(t)).error() : RequestError.application_error;
        if (error == RequestError.application_error) {
            response.sendError(error.code(), error.message());
        } else {
            response.getWriter().write("Error (" + error.code() + ") : " + error.message() + "\nStacktrace:\n");
            t.printStackTrace(response.getWriter());
            response.setStatus(error.code());
        }
    }
}

