/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-validation")
public class RequestValidator
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext context;

    @Override
    public void handleRequest(RequestEvent call) {
        this.context = (ApplicationContext)call.context();
        this.validateAgainstLifecycle(call);
        this.validateScope(call);
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.context.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScope(RequestEvent call) {
        String scope = call.request().getHeader("gcube-scope");
        if (scope == null) {
            log.info("rejecting unscoped call to {}", (Object)this.context.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        if (!this.context.profile(GCoreEndpoint.class).scopes().contains((Object)scope)) {
            log.info("rejecting call to {} in invalid scope {}", (Object)this.context.name(), (Object)scope);
            RequestError.invalid_request_error.fire(this.context.name() + " cannot be called in scope " + scope);
        }
        log.info("received call to {} in scope {}", (Object)call.uri(), (Object)scope);
        ScopeProvider.instance.set(scope);
    }

    @Override
    public String toString() {
        return "request-validation";
    }
}

