/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class FastDataInputStream
extends BufferedInputStream
implements DataInput {
    private final byte[] readBuffer = new byte[8];

    public FastDataInputStream(InputStream in, int size) {
        super(in, size);
    }

    @Override
    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int cur = 0;
        for (int sum = 0; sum < len; sum += cur) {
            cur = this.read(b, off + sum, len - sum);
            if (cur < 0) {
                throw new EOFException();
            }
            sum += cur;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch;
        if (this.pos >= this.count) {
            this.fillNew();
            if (this.pos >= this.count) {
                throw new EOFException();
            }
        }
        return (ch = this.buf[this.pos++] & 0xFF) != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.pos >= this.count) {
            this.fillNew();
            if (this.pos >= this.count) {
                throw new EOFException();
            }
        }
        return this.buf[this.pos++];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pos >= this.count) {
            this.fillNew();
            if (this.pos >= this.count) {
                throw new EOFException();
            }
        }
        int ch = this.buf[this.pos++] & 0xFF;
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        if (this.pos + 1 >= this.count) {
            this.fillNew();
            if (this.pos + 1 >= this.count) {
                throw new EOFException();
            }
        }
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.pos + 1 >= this.count) {
            this.fillNew();
            if (this.pos + 1 >= this.count) {
                throw new EOFException();
            }
        }
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (ch1 << 8) + ch2;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.pos + 1 >= this.count) {
            this.fillNew();
            if (this.pos + 1 >= this.count) {
                throw new EOFException();
            }
        }
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public final int readInt() throws IOException {
        if (this.pos + 3 >= this.count) {
            this.fillNew();
            if (this.pos + 3 >= this.count) {
                throw new EOFException();
            }
        }
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        int ch3 = this.buf[this.pos++] & 0xFF;
        int ch4 = this.buf[this.pos++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)(this.readBuffer[7] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    private void fillNew() throws IOException {
        int remain = 0;
        if (this.pos < this.count) {
            remain = this.count - this.pos;
            System.arraycopy(this.buf, this.pos, this.buf, 0, remain);
        }
        this.pos = 0;
        int n = this.in.read(this.buf, remain, this.buf.length - remain);
        this.count = this.pos + n + remain;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int sum;
        int avail = this.count - this.pos;
        int cur = 0;
        if (avail <= 0) {
            for (sum = 0; sum < n && (cur = (int)this.in.skip(n - sum)) > 0; sum += cur) {
            }
            return sum;
        }
        if (n > avail) {
            this.pos += avail;
            sum += avail;
            while (sum < n && (cur = (int)this.in.skip(n - sum)) > 0) {
                sum += cur;
            }
            return sum;
        }
        this.pos += n;
        return n;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }
}

