/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Packet.Sent.Icq;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Flap;
import JOscarLib.RawData;
import JOscarLib.Setting.Enum.MetaSubCommandEnum;
import JOscarLib.Setting.Enum.MetaSubTypeEnum;
import JOscarLib.Snac;
import JOscarLib.Tlv;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ClientMeta
extends Flap {
    private static final byte[] unknownSMSField = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int REQUEST_ACK_LENGHT = 2048;
    private static final int SMS_LENGHT = 297;
    private Tlv tlv1;

    private ClientMeta(String userId, int lenght, MetaSubCommandEnum subCommand) {
        super(2);
        this.tlv1 = new Tlv(new RawData(lenght, 2), 1);
        RawData rUin = new RawData(Integer.parseInt(userId), 4);
        rUin.invertIndianness();
        this.tlv1.appendRawDataToTlv(rUin);
        this.tlv1.appendRawDataToTlv(new RawData(subCommand.getSubCommand(), 2));
        this.tlv1.appendRawDataToTlv(new RawData(0, 2));
    }

    private ClientMeta(String userId, int lenght, MetaSubCommandEnum subCommand, MetaSubTypeEnum subType) {
        this(userId, lenght, subCommand);
        this.tlv1.appendRawDataToTlv(new RawData(subType.getSubType()));
    }

    private static ClientMeta finalizePacket(ClientMeta meta, Tlv tlv1) {
        Snac snac = new Snac(21, 2, 0, 0, 0);
        snac.addTlvToSnac(tlv1);
        meta.addSnac(snac);
        return meta;
    }

    public static ClientMeta requestOfflineMessages(OscarConnection connection) {
        ClientMeta meta = new ClientMeta(connection.getUserId(), 2048, new MetaSubCommandEnum(15360));
        ClientMeta.finalizePacket(meta, meta.tlv1);
        return meta;
    }

    public static ClientMeta ackOfflineMessages(OscarConnection connection) {
        ClientMeta meta = new ClientMeta(connection.getUserId(), 2048, new MetaSubCommandEnum(15872));
        ClientMeta.finalizePacket(meta, meta.tlv1);
        return meta;
    }

    public static ClientMeta sendSMS(OscarConnection connection, String cellNumber, String message) {
        int totalLenght = 297 + cellNumber.length() + message.length() + connection.getUserId().length() * 2;
        RawData rawLenght = new RawData(totalLenght, 2);
        rawLenght.invertIndianness();
        totalLenght = rawLenght.getValue();
        ClientMeta meta = new ClientMeta(connection.getUserId(), totalLenght, new MetaSubCommandEnum(53255), new MetaSubTypeEnum(33300));
        meta.tlv1.appendRawDataToTlv(new RawData(1, 2));
        meta.tlv1.appendRawDataToTlv(new RawData(22, 2));
        meta.tlv1.appendRawDataToTlv(new RawData(unknownSMSField));
        SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("EN", Locale.getDefault().getCountry()));
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String time = dateFormatter.format(new Date());
        String smsMessage = new String();
        smsMessage = smsMessage + "<icq_sms_message>";
        smsMessage = smsMessage + "<destination>" + cellNumber + "</destination>";
        smsMessage = smsMessage + "<text>" + message + "</text>";
        smsMessage = smsMessage + "<codepage>1252</codepage>";
        smsMessage = smsMessage + "<encoding>utf8</encoding>";
        smsMessage = smsMessage + "<senders_UIN>" + connection.getUserId() + "</senders_UIN>";
        smsMessage = smsMessage + "<senders_name>" + connection.getUserId() + "</senders_name>";
        smsMessage = smsMessage + "<delivery_receipt>Yes</delivery_receipt>";
        smsMessage = smsMessage + "<time>" + time + "</time>";
        smsMessage = smsMessage + "</icq_sms_message>";
        Tlv tlvMessage = new Tlv(smsMessage, 0);
        meta.tlv1.appendTlvToTlv(tlvMessage);
        ClientMeta.finalizePacket(meta, meta.tlv1);
        return meta;
    }
}

