/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import org.apache.poi.hslf.record.TextAutoNumberSchemeEnum;
import org.apache.poi.util.LittleEndian;

public class TextPFException9 {
    private final byte mask3;
    private final byte mask4;
    private final Short bulletBlipRef;
    private final Short fBulletHasAutoNumber;
    private final TextAutoNumberSchemeEnum autoNumberScheme;
    private static final TextAutoNumberSchemeEnum DEFAULT_AUTONUMBER_SHEME = TextAutoNumberSchemeEnum.ANM_ArabicPeriod;
    private final Short autoNumberStartNumber;
    private static final Short DEFAULT_START_NUMBER = new Short(1);
    private final int recordLength;

    public TextPFException9(byte[] source, int startIndex) {
        this.mask3 = source[startIndex + 2];
        this.mask4 = source[startIndex + 3];
        int length = 4;
        int index = startIndex + 4;
        if (0 == (this.mask3 & 0xFFFFFF80)) {
            this.bulletBlipRef = null;
        } else {
            this.bulletBlipRef = LittleEndian.getShort((byte[])source, (int)index);
            index += 2;
            length = 6;
        }
        if (0 == (this.mask4 & 2)) {
            this.fBulletHasAutoNumber = null;
        } else {
            this.fBulletHasAutoNumber = LittleEndian.getShort((byte[])source, (int)index);
            index += 2;
            length += 2;
        }
        if (0 == (this.mask4 & 1)) {
            this.autoNumberScheme = null;
            this.autoNumberStartNumber = null;
        } else {
            this.autoNumberScheme = TextAutoNumberSchemeEnum.valueOf(LittleEndian.getShort((byte[])source, (int)index));
            this.autoNumberStartNumber = LittleEndian.getShort((byte[])source, (int)(index += 2));
            index += 2;
            length += 4;
        }
        this.recordLength = length;
    }

    public Short getBulletBlipRef() {
        return this.bulletBlipRef;
    }

    public Short getfBulletHasAutoNumber() {
        return this.fBulletHasAutoNumber;
    }

    public TextAutoNumberSchemeEnum getAutoNumberScheme() {
        if (null != this.autoNumberScheme) {
            return this.autoNumberScheme;
        }
        if (null != this.fBulletHasAutoNumber && 1 == this.fBulletHasAutoNumber) {
            return DEFAULT_AUTONUMBER_SHEME;
        }
        return null;
    }

    public Short getAutoNumberStartNumber() {
        if (null != this.autoNumberStartNumber) {
            return this.autoNumberStartNumber;
        }
        if (null != this.fBulletHasAutoNumber && 1 == this.fBulletHasAutoNumber) {
            return DEFAULT_START_NUMBER;
        }
        return null;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Record length: ").append(this.recordLength).append(" bytes\n");
        sb.append("bulletBlipRef: ").append(this.bulletBlipRef).append("\n");
        sb.append("fBulletHasAutoNumber: ").append(this.fBulletHasAutoNumber).append("\n");
        sb.append("autoNumberScheme: ").append((Object)this.autoNumberScheme).append("\n");
        sb.append("autoNumberStartNumber: ").append(this.autoNumberStartNumber).append("\n");
        return sb.toString();
    }
}

