/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.search.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ContentUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    private static Log _log = LogFactoryUtil.getLog(ConfigurationActionImpl.class);

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        boolean advancedConfiguration = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "advancedConfiguration"));
        if (!advancedConfiguration) {
            this.updateBasicConfiguration(portletConfig, actionRequest, actionResponse);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected void updateBasicConfiguration(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        boolean displayScopeFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayScopeFacet"));
        boolean displayAssetCategoriesFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayAssetCategoriesFacet"));
        boolean displayAssetTagsFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayAssetTagsFacet"));
        boolean displayAssetTypeFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayAssetTypeFacet"));
        boolean displayFolderFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayFolderFacet"));
        boolean displayUserFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayUserFacet"));
        boolean displayModifiedRangeFacet = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "displayModifiedRangeFacet"));
        String searchConfiguration = ContentUtil.get((String)PropsValues.SEARCH_FACET_CONFIGURATION);
        JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject((String)searchConfiguration);
        JSONArray oldFacetsJSONArray = configurationJSONObject.getJSONArray("facets");
        if (oldFacetsJSONArray == null && _log.isWarnEnabled()) {
            _log.warn((Object)("The resource " + PropsValues.SEARCH_FACET_CONFIGURATION + " is missing a valid facets JSON array"));
        }
        JSONArray newFacetsJSONArray = JSONFactoryUtil.createJSONArray();
        int i2 = 0;
        while (i2 < oldFacetsJSONArray.length()) {
            JSONObject oldFacetJSONObject = oldFacetsJSONArray.getJSONObject(i2);
            String fieldName = oldFacetJSONObject.getString("fieldName");
            if (displayScopeFacet && fieldName.equals("groupId") || displayAssetCategoriesFacet && fieldName.equals("assetCategoryIds") || displayAssetTagsFacet && fieldName.equals("assetTagNames") || displayAssetTypeFacet && fieldName.equals("entryClassName") || displayFolderFacet && fieldName.equals("folderId") || displayUserFacet && fieldName.equals("userId") || displayModifiedRangeFacet && fieldName.equals("modified")) {
                newFacetsJSONArray.put(oldFacetJSONObject);
            }
            ++i2;
        }
        configurationJSONObject.put("facets", newFacetsJSONArray);
        searchConfiguration = configurationJSONObject.toString();
        this.setPreference((PortletRequest)actionRequest, "searchConfiguration", searchConfiguration);
    }
}

