/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.googleapps.GAuthenticator;
import com.liferay.portal.googleapps.GBaseManagerImpl;
import com.liferay.portal.googleapps.GetNextItems;
import com.liferay.portal.googleapps.GoogleApps;
import com.liferay.portal.kernel.googleapps.GNickname;
import com.liferay.portal.kernel.googleapps.GNicknameManager;
import com.liferay.portal.kernel.googleapps.GoogleAppsException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.List;

public class GNicknameManagerImpl
extends GBaseManagerImpl
implements GNicknameManager {
    protected String nicknameURL;
    private static Log _log = LogFactoryUtil.getLog(GNicknameManagerImpl.class);

    public GNicknameManagerImpl(GoogleApps googleApps) {
        super(googleApps);
        GAuthenticator gAuthenticator = googleApps.getGAuthenticator();
        StringBundler sb = new StringBundler(4);
        sb.append("https://apps-apis.google.com/a/feeds");
        sb.append("/");
        sb.append(gAuthenticator.getDomain());
        sb.append("/nickname/2.0");
        this.nicknameURL = sb.toString();
    }

    public void addGNickname(long userId, String nickname) throws GoogleAppsException {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntryElement = this.addAtomEntry(document);
        this.addAtomCategory(atomEntryElement, "nickname");
        Element appsLoginElement = atomEntryElement.addElement("apps:login");
        appsLoginElement.addAttribute("userName", String.valueOf(userId));
        Element appsNicknameElement = atomEntryElement.addElement("apps:nickname");
        appsNicknameElement.addAttribute("name", nickname);
        this.submitAdd(this.nicknameURL, document);
    }

    public void deleteGNickname(String nickname) throws GoogleAppsException {
        this.submitDelete(this.getNicknameURL(nickname));
    }

    public GNickname getGNickname(String nickname) throws GoogleAppsException {
        Document document = this.getDocument(this.getNicknameURL(nickname));
        if (this.hasError(document)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)this.getErrorMessage(document));
            }
            return null;
        }
        Element atomEntryElement = document.getRootElement();
        return this.getGNickname(atomEntryElement);
    }

    public List<GNickname> getGNicknames() throws GoogleAppsException {
        ArrayList<GNickname> gNicknames = new ArrayList<GNickname>();
        this.getGNicknames(gNicknames, this.nicknameURL);
        return gNicknames;
    }

    protected GNickname getGNickname(Element atomEntryElement) {
        GNickname gNickname = new GNickname();
        Element appsLoginElement = atomEntryElement.element(this.getAppsQName("login"));
        Element appsNicknameElement = atomEntryElement.element(this.getAppsQName("nickname"));
        String nickname = appsNicknameElement.attributeValue("name");
        gNickname.setNickname(nickname);
        long userId = GetterUtil.getLong((String)appsLoginElement.attributeValue("userName"));
        gNickname.setUserId(userId);
        return gNickname;
    }

    protected void getGNicknames(final List<GNickname> gNicknames, String url) throws GoogleAppsException {
        Document document = this.getDocument(url);
        Element atomFeedElement = document.getRootElement();
        List atomEntryElements = atomFeedElement.elements(this.getAtomQName("entry"));
        for (Element atomEntryElement : atomEntryElements) {
            GNickname gNickname = this.getGNickname(atomEntryElement);
            gNicknames.add(gNickname);
        }
        new GetNextItems(url, atomFeedElement){

            @Override
            public void getNextItems(String nextURL) throws GoogleAppsException {
                GNicknameManagerImpl.this.getGNicknames(gNicknames, nextURL);
            }
        };
    }

    protected String getNicknameURL(String nickname) {
        return this.nicknameURL.concat("/").concat(nickname);
    }
}

