/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.forms;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.forms.FormElement;
import com.ecyrd.jspwiki.forms.FormInfo;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class FormOpen
extends FormElement {
    private static Logger log = Logger.getLogger(FormOpen.class);
    public static final String PARAM_METHOD = "method";

    public String execute(WikiContext ctx, Map params) throws PluginException {
        String method;
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        String formName = (String)params.get("form");
        if (formName == null) {
            Object[] args = new Object[]{"form"};
            throw new PluginException(MessageFormat.format(rb.getString("formopen.missingparam"), args));
        }
        String hide = (String)params.get("hide");
        String sourcePage = ctx.getPage().getName();
        String submitServlet = (String)params.get("submit");
        if (submitServlet == null) {
            submitServlet = ctx.getURL(WikiContext.VIEW, sourcePage);
        }
        if ((method = (String)params.get(PARAM_METHOD)) == null) {
            method = "post";
        }
        if (!method.equalsIgnoreCase("get") && !method.equalsIgnoreCase("post")) {
            throw new PluginException(rb.getString("formopen.postorgetonly"));
        }
        FormInfo info = this.getFormInfo(ctx);
        if (info != null) {
            if (formName.equals(info.getName())) {
                log.debug((Object)"Previous FormInfo for this form was found in context.");
                if (hide != null && "onsuccess".equals(hide) && info.getStatus() == 1) {
                    info.setHide(true);
                    return "<p>" + rb.getString("formopen.noneedtoshow") + "</p>";
                }
            } else {
                info = new FormInfo();
            }
        } else {
            info = new FormInfo();
            this.storeFormInfo(ctx, info);
        }
        info.setName(formName);
        info.setAction(submitServlet);
        StringBuffer tag = new StringBuffer(40);
        tag.append("<div class=\"wikiform\">\n");
        tag.append("<form action=\"" + submitServlet);
        tag.append("\" name=\"" + formName);
        tag.append("\" accept-charset=\"" + ctx.getEngine().getContentEncoding());
        tag.append("\" method=\"" + method + "\" enctype=\"application/x-www-form-urlencoded\">\n");
        tag.append("  <input type=\"hidden\" name=\"formname");
        tag.append("\" value=\"" + formName + "\"/>\n");
        return tag.toString();
    }
}

