/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureLinkLocalServiceBaseImpl;
import java.util.List;

public class DDMStructureLinkLocalServiceImpl
extends DDMStructureLinkLocalServiceBaseImpl {
    public DDMStructureLink addStructureLink(long classNameId, long classPK, long structureId, ServiceContext serviceContext) throws SystemException {
        long structureLinkId = this.counterLocalService.increment();
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.create(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
        return structureLink;
    }

    public void deleteClassStructureLink(long classPK) throws PortalException, SystemException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByClassPK(classPK);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureLink(DDMStructureLink structureLink) throws SystemException {
        this.ddmStructureLinkPersistence.remove((BaseModel)structureLink);
    }

    public void deleteStructureLink(long structureLinkId) throws PortalException, SystemException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureStructureLinks(long structureId) throws SystemException {
        List structureLinks = this.ddmStructureLinkPersistence.findByStructureId(structureId);
        for (DDMStructureLink structureLink : structureLinks) {
            this.deleteStructureLink(structureLink);
        }
    }

    public DDMStructureLink getClassStructureLink(long classPK) throws PortalException, SystemException {
        return this.ddmStructureLinkPersistence.findByClassPK(classPK);
    }

    public List<DDMStructureLink> getClassStructureLinks(long classNameId) throws SystemException {
        return this.ddmStructureLinkPersistence.findByStructureId(classNameId);
    }

    public DDMStructureLink getStructureLink(long structureLinkId) throws PortalException, SystemException {
        return this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId, int start, int end) throws SystemException {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId, start, end);
    }

    public DDMStructureLink updateStructureLink(long structureLinkId, long classNameId, long classPK, long structureId) throws PortalException, SystemException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
        return structureLink;
    }
}

