/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;

public class UpgradeTableBuilder {
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        try {
            new UpgradeTableBuilder(args[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public UpgradeTableBuilder(String upgradeTableDir) throws Exception {
        String[] fileNames;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(".");
        ds.setIncludes(new String[]{"**\\upgrade\\v**\\util\\*Table.java"});
        ds.scan();
        String[] stringArray = fileNames = ds.getIncludedFiles();
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            int y;
            int x;
            String fileName = stringArray[n2];
            String version = StringUtil.replace((String)(fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/")).substring((x = fileName.indexOf("upgrade/v")) + 9, y = fileName.indexOf("/util", x)), (String)"_", (String)".");
            String upgradeFileVersion = version;
            int z = upgradeFileVersion.indexOf(".to.");
            if (z != -1) {
                upgradeFileVersion = upgradeFileVersion.substring(z + 4);
            }
            x = fileName.indexOf("/", y + 1);
            y = fileName.indexOf("Table.java", x);
            String upgradeFileName = String.valueOf(upgradeTableDir) + "/" + upgradeFileVersion + "/" + fileName.substring(x, y) + "ModelImpl.java";
            if (_fileUtil.exists(upgradeFileName) || upgradeFileVersion.equals(ReleaseInfo.getVersion()) && (upgradeFileName = this._findUpgradeFileName(fileName.substring(x, y))) != null) {
                String content = _fileUtil.read(upgradeFileName);
                String packagePath = "com.liferay.portal.upgrade.v" + StringUtil.replace((String)version, (String)".", (String)"_") + ".util";
                String className = String.valueOf(fileName.substring(x + 1, y)) + "Table";
                String author = this._getAuthor(fileName);
                String[] addIndexes = this._getAddIndexes(String.valueOf(upgradeTableDir) + "/" + upgradeFileVersion + "/indexes.sql", fileName.substring(x + 1, y));
                content = this._getContent(packagePath, className, content, author, addIndexes);
                _fileUtil.write(fileName, content);
            }
            ++n2;
        }
    }

    private String _findUpgradeFileName(String modelName) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(".");
        ds.setIncludes(new String[]{"**\\" + modelName + "ModelImpl.java"});
        ds.scan();
        String[] fileNames = ds.getIncludedFiles();
        if (fileNames.length > 0) {
            return fileNames[0];
        }
        return null;
    }

    private String[] _getAddIndexes(String indexesFileName, String tableName) throws Exception {
        ArrayList<String> addIndexes = new ArrayList<String>();
        File indexesFile = new File(indexesFileName);
        if (!indexesFile.exists()) {
            indexesFile = new File("../sql/indexes.sql");
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(new FileInputStream(indexesFile)));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains(" on " + tableName + " (") && !line.contains(" on " + tableName + "_ (")) continue;
            String sql = line.trim();
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            addIndexes.add(sql);
        }
        unsyncBufferedReader.close();
        return addIndexes.toArray(new String[addIndexes.size()]);
    }

    private String _getAuthor(String fileName) throws Exception {
        int y;
        String content;
        int x;
        if (_fileUtil.exists(fileName) && (x = (content = _fileUtil.read(fileName)).indexOf("* @author ")) != -1 && (y = content.indexOf("*", x + 1)) != -1) {
            return content.substring(x + 10, y).trim();
        }
        return "Brian Wing Shun Chan";
    }

    private String _getContent(String packagePath, String className, String content, String author, String[] addIndexes) throws Exception {
        String[] lines;
        int y;
        int x = content.indexOf("public static final String TABLE_NAME =");
        if (x == -1) {
            x = content.indexOf("public static String TABLE_NAME =");
        }
        if ((y = content.indexOf("public static final String TABLE_SQL_DROP =")) == -1) {
            y = content.indexOf("public static String TABLE_SQL_DROP =");
        }
        y = content.indexOf(";", y);
        content = content.substring(x, y + 1);
        content = StringUtil.replace((String)content, (String[])new String[]{"\t", "{ \"", "new Integer(Types.", ") }", " }"}, (String[])new String[]{"", "{\"", "Types.", "}", "}"});
        while (content.contains("\n\n")) {
            content = StringUtil.replace((String)content, (String)"\n\n", (String)"\n");
        }
        StringBundler sb = new StringBundler();
        sb.append(_fileUtil.read("../copyright.txt"));
        sb.append("\n\npackage ");
        sb.append(packagePath);
        sb.append(";\n\n");
        sb.append("import java.sql.Types;\n\n");
        sb.append("/**\n");
        sb.append(" * @author\t  ");
        sb.append(author);
        sb.append("\n");
        sb.append(" * @generated\n");
        sb.append(" */\n");
        sb.append("public class ");
        sb.append(className);
        sb.append(" {\n\n");
        String[] stringArray = lines = StringUtil.splitLines((String)content);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("public static") || line.startsWith("};")) {
                sb.append("\t");
            } else if (line.startsWith("{\"")) {
                sb.append("\t\t");
            }
            sb.append(line);
            sb.append("\n");
            if (line.endsWith(";")) {
                sb.append("\n");
            }
            ++n2;
        }
        sb.append("\tpublic static final String[] TABLE_SQL_ADD_INDEXES = {\n");
        int i2 = 0;
        while (i2 < addIndexes.length) {
            String addIndex = addIndexes[i2];
            sb.append("\t\t\"");
            sb.append(addIndex);
            sb.append("\"");
            if (i2 + 1 < addIndexes.length) {
                sb.append(",");
            }
            sb.append("\n");
            ++i2;
        }
        sb.append("\t};\n\n");
        sb.append("}");
        return sb.toString();
    }
}

