/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.surround.query.TooManyBasicQueries;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;

public class BasicQueryFactory {
    private int maxBasicQueries;
    private int queriesMade;

    public BasicQueryFactory(int maxBasicQueries) {
        this.maxBasicQueries = maxBasicQueries;
        this.queriesMade = 0;
    }

    public BasicQueryFactory() {
        this(1024);
    }

    public int getNrQueriesMade() {
        return this.queriesMade;
    }

    public int getMaxBasicQueries() {
        return this.maxBasicQueries;
    }

    private synchronized void checkMax() throws TooManyBasicQueries {
        if (this.queriesMade >= this.maxBasicQueries) {
            throw new TooManyBasicQueries(this.getMaxBasicQueries());
        }
        ++this.queriesMade;
    }

    public TermQuery newTermQuery(Term term) throws TooManyBasicQueries {
        this.checkMax();
        return new TermQuery(term);
    }

    public SpanTermQuery newSpanTermQuery(Term term) throws TooManyBasicQueries {
        this.checkMax();
        return new SpanTermQuery(term);
    }
}

