/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.Jdk14LogImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import java.io.InputStream;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Jdk14LogFactoryImpl
implements LogFactory {
    public Jdk14LogFactoryImpl() {
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        try {
            Class<?> clazz = this.getClass();
            InputStream inputStream = clazz.getResourceAsStream("/logging.properties");
            if (inputStream != null) {
                LogManager logManager = LogManager.getLogManager();
                logManager.readConfiguration(inputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Log getLog(Class<?> c) {
        return this.getLog(c.getName());
    }

    @Override
    public Log getLog(String name) {
        return new Jdk14LogImpl(Logger.getLogger(name));
    }

    @Override
    public void setLevel(String name, String priority, boolean custom) {
    }
}

