/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.io.findfile.ClassFinder;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassLoaderUtil;
import jodd.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicMadvocConfigurator
extends ClassFinder
implements MadvocConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicMadvocConfigurator.class);
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ResultsManager resultsManager;
    protected String actionClassSuffix = "Action";
    protected String resultClassSuffix = "Result";
    protected long elapsed = 0L;

    public void configure() {
        this.configure(ClassLoaderUtil.getDefaultClasspath());
    }

    public void configure(File[] classpath) {
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanPaths(classpath);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to scan classpath.", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Madvoc configured in " + this.elapsed + " ms. Total actions: " + this.actionsManager.getActionsCount());
    }

    protected void onEntry(ClassFinder.EntryData entryData) {
        String entryName = entryData.getName();
        if (entryName.endsWith(this.actionClassSuffix)) {
            try {
                this.onActionClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new MadvocException("Unable to load Madvoc action class: " + entryName, cnfex);
            }
        }
        if (entryName.endsWith(this.resultClassSuffix)) {
            try {
                this.onResultClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new MadvocException("Unable to load Madvoc result class: " + entryName, cnfex);
            }
        }
    }

    public boolean checkClass(Class clazz) {
        try {
            if (clazz.isAnonymousClass()) {
                return false;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                return false;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz.isLocalClass()) {
                return false;
            }
            if (clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers())) {
                return false;
            }
            return !clazz.isPrimitive();
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    protected void onActionClass(String className) throws ClassNotFoundException {
        Method[] allPublicMethods;
        Class actionClass = ClassLoaderUtil.loadClass(className);
        if (!this.checkClass(actionClass)) {
            return;
        }
        if (actionClass.getAnnotation(MadvocAction.class) == null) {
            return;
        }
        ClassDescriptor cd = ClassIntrospector.lookup(actionClass);
        for (Method method : allPublicMethods = cd.getAllMethods(false)) {
            boolean hasAnnotation = false;
            for (ActionAnnotation<?> actionAnnotation : this.madvocConfig.getActionAnnotationInstances()) {
                if (!actionAnnotation.hasAnnotation(method)) continue;
                hasAnnotation = true;
                break;
            }
            if (!hasAnnotation) continue;
            this.actionsManager.register(actionClass, method);
        }
    }

    protected void onResultClass(String className) throws ClassNotFoundException {
        Class resultClass = ClassLoaderUtil.loadClass(className);
        if (resultClass.equals(ActionResult.class)) {
            return;
        }
        if (ReflectUtil.isSubclass(resultClass, ActionResult.class)) {
            this.resultsManager.register(resultClass);
        }
    }
}

