/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.util.StringUtil;

public class HtmlImplicitClosingRules {
    public static final String[][] IMPLIED_ON_START = new String[][]{{"p"}, {"address", "article", "aside", "blockquote", "center", "details", "dir", "div", "dl", "fieldset", "figcaption", "figure", "footer", "header", "hgroup", "menu", "nav", "ol", "p", "section", "summary", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "listing", "form", "li", "dd", "dt", "plaintext", "table", "hr", "xmp"}, {"dd", "dt"}, {"dd", "dt"}, {"li"}, {"li"}, {"td"}, {"td"}, {"th"}, {"th"}, {"tr", "td", "th", "colgroup"}, {"tr"}, {"thead", "tr", "td", "th", "colgroup"}, {"tbody"}, {"tbody", "tr", "td", "th"}, {"tfoot"}, {"colgroup"}, {"thead"}, {"colgroup"}, {"colgroup"}, {"optgroup"}, {"optgroup"}, {"head"}, {"body"}};
    public static final String[][] IMPLIED_ON_END = new String[][]{{"dl"}, {"dd", "dt"}, {"ul", "ol"}, {"li"}, {"table"}, {"th", "td", "tr", "tbody", "tfoot", "thead"}, {"select"}, {"optgroup"}, {"body"}, {"dd", "dt", "li", "optgroup", "option", "p", "tbody", "td", "tfoot", "th", "thead", "tr", "html"}, {"html"}, {"dd", "dt", "li", "optgroup", "option", "p", "tbody", "td", "tfoot", "th", "thead", "tr", "body"}};
    public static final String[] CLOSED_ON_EOF = new String[]{"dd", "dt", "li", "p", "tbody", "td", "tfoot", "th", "thead", "tr", "body", "html"};

    public boolean implicitlyCloseParentTagOnNewTag(String parentNodeName, String nodeName) {
        if (parentNodeName == null) {
            return false;
        }
        parentNodeName = parentNodeName.toLowerCase();
        nodeName = nodeName.toLowerCase();
        for (int i = 0; i < IMPLIED_ON_START.length; i += 2) {
            if (StringUtil.equalsOne(parentNodeName, IMPLIED_ON_START[i]) == -1 || StringUtil.equalsOne(nodeName, IMPLIED_ON_START[i + 1]) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean implicitlyCloseParentTagOnTagEnd(String parentNodeName, String nodeName) {
        if (parentNodeName == null) {
            return false;
        }
        parentNodeName = parentNodeName.toLowerCase();
        nodeName = nodeName.toLowerCase();
        for (int i = 0; i < IMPLIED_ON_END.length; i += 2) {
            if (StringUtil.equalsOne(nodeName, IMPLIED_ON_END[i]) == -1 || StringUtil.equalsOne(parentNodeName, IMPLIED_ON_END[i + 1]) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean implicitlyCloseTagOnEOF(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return StringUtil.equalsOne(nodeName = nodeName.toLowerCase(), CLOSED_ON_EOF) != -1;
    }
}

