/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class TableDerived
extends Table {
    QueryExpression queryExpression;
    View view;
    SubQuery subQuery;

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type) {
        super(database, name, type);
        switch (type) {
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type, QueryExpression queryExpression, SubQuery subQuery) {
        super(database, name, type);
        switch (type) {
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.queryExpression = queryExpression;
        this.subQuery = subQuery;
    }

    public TableDerived(Database database, HsqlNameManager.HsqlName name, int type, Type[] columnTypes, HashMappedList columnList, QueryExpression queryExpression, SubQuery subQuery) {
        this(database, name, type, queryExpression, subQuery);
        this.colTypes = columnTypes;
        this.columnList = columnList;
        this.columnCount = columnList.size();
        this.primaryKeyCols = ValuePool.emptyIntArray;
        this.primaryKeyTypes = Type.emptyArray;
        this.primaryKeyColsSequence = ValuePool.emptyIntArray;
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        ArrayUtil.fillSequence(this.defaultColumnMap);
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, null);
    }

    public int getId() {
        return 0;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isInsertable() {
        return this.queryExpression == null ? false : this.queryExpression.isInsertable();
    }

    public boolean isUpdatable() {
        return this.queryExpression == null ? false : this.queryExpression.isUpdatable();
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this.queryExpression == null ? this : this.queryExpression.getBaseTable();
    }

    public int[] getBaseTableColumnMap() {
        return this.queryExpression == null ? null : this.queryExpression.getBaseTableColumnMap();
    }

    public SubQuery getSubQuery() {
        return this.subQuery;
    }

    public QueryExpression getQueryExpression() {
        return this.queryExpression;
    }
}

