/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.EISCollectionChangeRecord {
    private Vector adds;
    private Vector removes;
    private Vector changedMapKeys;

    public EISCollectionChangeRecord(ObjectChangeSet owner, String attributeName, DatabaseMapping mapping) {
        this.owner = owner;
        this.attribute = attributeName;
        this.mapping = mapping;
    }

    public void addAddedChangeSet(Object changeSet) {
        this.getAdds().addElement(changeSet);
    }

    public void addChangedMapKeyChangeSet(Object changeSet) {
        this.getChangedMapKeys().addElement(changeSet);
    }

    public void addRemovedChangeSet(Object changeSet) {
        this.getRemoves().addElement(changeSet);
    }

    public Vector getAdds() {
        if (this.adds == null) {
            this.adds = new Vector(1);
        }
        return this.adds;
    }

    public Vector getChangedMapKeys() {
        if (this.changedMapKeys == null) {
            this.changedMapKeys = new Vector(1);
        }
        return this.changedMapKeys;
    }

    public Vector getRemoves() {
        if (this.removes == null) {
            this.removes = new Vector(1);
        }
        return this.removes;
    }

    private boolean hasAdds() {
        return this.adds != null && !this.adds.isEmpty();
    }

    private boolean hasChangedMapKeys() {
        return this.changedMapKeys != null && !this.changedMapKeys.isEmpty();
    }

    public boolean hasChanges() {
        return this.hasAdds() || this.hasRemoves() || this.hasChangedMapKeys() || this.getOwner().isNew();
    }

    private boolean hasRemoves() {
        return this.removes != null && !this.removes.isEmpty();
    }

    private boolean removeAddedChangeSet(Object changeSet) {
        if (this.adds == null) {
            return false;
        }
        return this.adds.remove(changeSet);
    }

    private boolean removeRemovedChangeSet(Object changeSet) {
        if (this.removes == null) {
            return false;
        }
        return this.removes.remove(changeSet);
    }

    public void simpleAddChangeSet(Object changeSet) {
        if (!this.removeRemovedChangeSet(changeSet)) {
            this.addAddedChangeSet(changeSet);
        }
    }

    public void simpleRemoveChangeSet(Object changeSet) {
        if (!this.removeAddedChangeSet(changeSet)) {
            this.addRemovedChangeSet(changeSet);
        }
    }
}

