/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TimeZone;

public class PeriodList
extends TreeSet
implements Serializable {
    private static final long serialVersionUID = -6319585959747194724L;
    private TimeZone timezone;
    private boolean utc;

    public PeriodList() {
        this(true);
    }

    public PeriodList(boolean utc) {
        this.utc = utc;
    }

    public PeriodList(String aValue) throws ParseException {
        this();
        StringTokenizer t = new StringTokenizer(aValue, ",");
        while (t.hasMoreTokens()) {
            this.add((Object)new Period(t.nextToken()));
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next().toString());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(Period period) {
        if (this.isUtc()) {
            period.setUtc(true);
        } else {
            period.setTimeZone(this.timezone);
        }
        return this.add((Object)period);
    }

    public final boolean add(Object period) {
        if (!(period instanceof Period)) {
            throw new IllegalArgumentException("Argument not a " + Period.class.getName());
        }
        return super.add(period);
    }

    public final boolean remove(Period period) {
        return this.remove((Object)period);
    }

    public final PeriodList normalise() {
        Period prevPeriod = null;
        Period period = null;
        PeriodList newList = new PeriodList(this.isUtc());
        if (this.timezone != null) {
            newList.setTimeZone(this.timezone);
        }
        boolean normalised = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            period = (Period)i.next();
            if (period.isEmpty()) {
                period = prevPeriod;
                normalised = true;
            } else if (prevPeriod != null) {
                if (prevPeriod.contains(period)) {
                    period = prevPeriod;
                    normalised = true;
                } else if (prevPeriod.intersects(period)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else if (prevPeriod.adjacent(period)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else {
                    newList.add(prevPeriod);
                }
            }
            prevPeriod = period;
        }
        if (prevPeriod != null) {
            newList.add(prevPeriod);
        }
        if (normalised) {
            return newList;
        }
        return this;
    }

    public final PeriodList add(PeriodList periods) {
        if (periods != null) {
            PeriodList newList = new PeriodList();
            newList.addAll(this);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                newList.add((Period)i.next());
            }
            return newList.normalise();
        }
        return this;
    }

    public final PeriodList subtract(PeriodList subtractions) {
        if (subtractions == null || subtractions.isEmpty()) {
            return this;
        }
        PeriodList result = this;
        PeriodList tmpResult = new PeriodList();
        Iterator i = subtractions.iterator();
        while (i.hasNext()) {
            Period subtraction = (Period)i.next();
            Iterator j = result.iterator();
            while (j.hasNext()) {
                Period period = (Period)j.next();
                tmpResult.addAll(period.subtract(subtraction));
            }
            result = tmpResult;
            tmpResult = new PeriodList();
        }
        return result;
    }

    public final boolean isUtc() {
        return this.utc;
    }

    public final void setUtc(boolean utc) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            period.setUtc(utc);
        }
        this.timezone = null;
        this.utc = utc;
    }

    public final void setTimeZone(TimeZone timeZone) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            period.setTimeZone(timeZone);
        }
        this.timezone = timeZone;
        this.utc = false;
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }
}

