/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portlet.shopping.model.ShoppingOrderItem;
import com.liferay.portlet.shopping.model.impl.ShoppingOrderItemImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;

public class ShoppingOrderItemCacheModel
implements CacheModel<ShoppingOrderItem>,
Externalizable {
    public long orderItemId;
    public long orderId;
    public String itemId;
    public String sku;
    public String name;
    public String description;
    public String properties;
    public double price;
    public int quantity;
    public long shippedDate;

    public String toString() {
        StringBundler sb = new StringBundler(21);
        sb.append("{orderItemId=");
        sb.append(this.orderItemId);
        sb.append(", orderId=");
        sb.append(this.orderId);
        sb.append(", itemId=");
        sb.append(this.itemId);
        sb.append(", sku=");
        sb.append(this.sku);
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        sb.append(", properties=");
        sb.append(this.properties);
        sb.append(", price=");
        sb.append(this.price);
        sb.append(", quantity=");
        sb.append(this.quantity);
        sb.append(", shippedDate=");
        sb.append(this.shippedDate);
        sb.append("}");
        return sb.toString();
    }

    public ShoppingOrderItem toEntityModel() {
        ShoppingOrderItemImpl shoppingOrderItemImpl = new ShoppingOrderItemImpl();
        shoppingOrderItemImpl.setOrderItemId(this.orderItemId);
        shoppingOrderItemImpl.setOrderId(this.orderId);
        if (this.itemId == null) {
            shoppingOrderItemImpl.setItemId("");
        } else {
            shoppingOrderItemImpl.setItemId(this.itemId);
        }
        if (this.sku == null) {
            shoppingOrderItemImpl.setSku("");
        } else {
            shoppingOrderItemImpl.setSku(this.sku);
        }
        if (this.name == null) {
            shoppingOrderItemImpl.setName("");
        } else {
            shoppingOrderItemImpl.setName(this.name);
        }
        if (this.description == null) {
            shoppingOrderItemImpl.setDescription("");
        } else {
            shoppingOrderItemImpl.setDescription(this.description);
        }
        if (this.properties == null) {
            shoppingOrderItemImpl.setProperties("");
        } else {
            shoppingOrderItemImpl.setProperties(this.properties);
        }
        shoppingOrderItemImpl.setPrice(this.price);
        shoppingOrderItemImpl.setQuantity(this.quantity);
        if (this.shippedDate == Long.MIN_VALUE) {
            shoppingOrderItemImpl.setShippedDate(null);
        } else {
            shoppingOrderItemImpl.setShippedDate(new Date(this.shippedDate));
        }
        shoppingOrderItemImpl.resetOriginalValues();
        return shoppingOrderItemImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.orderItemId = objectInput.readLong();
        this.orderId = objectInput.readLong();
        this.itemId = objectInput.readUTF();
        this.sku = objectInput.readUTF();
        this.name = objectInput.readUTF();
        this.description = objectInput.readUTF();
        this.properties = objectInput.readUTF();
        this.price = objectInput.readDouble();
        this.quantity = objectInput.readInt();
        this.shippedDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.orderItemId);
        objectOutput.writeLong(this.orderId);
        if (this.itemId == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.itemId);
        }
        if (this.sku == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.sku);
        }
        if (this.name == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.name);
        }
        if (this.description == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.description);
        }
        if (this.properties == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.properties);
        }
        objectOutput.writeDouble(this.price);
        objectOutput.writeInt(this.quantity);
        objectOutput.writeLong(this.shippedDate);
    }
}

