/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.nestedportlets.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    private static Pattern _pattern = Pattern.compile("processColumn[(]\"(.*?)\"(?:, *\"(?:.*?)\")?[)]", 32);

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String layoutTemplateId = this.getParameter((PortletRequest)actionRequest, "layoutTemplateId");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = actionRequest.getPreferences();
        String oldLayoutTemplateId = preferences.getValue("layoutTemplateId", PropsValues.NESTED_PORTLETS_LAYOUT_TEMPLATE_DEFAULT);
        if (!oldLayoutTemplateId.equals(layoutTemplateId)) {
            this.reorganizeNestedColumns(actionRequest, portletResource, layoutTemplateId, oldLayoutTemplateId);
        }
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected List<String> getColumnNames(String content, String portletId) {
        Matcher matcher = _pattern.matcher(content);
        HashSet<String> columnIds = new HashSet<String>();
        while (matcher.find()) {
            if (!Validator.isNotNull((String)matcher.group(1))) continue;
            columnIds.add(matcher.group(1));
        }
        UniqueList columnNames = new UniqueList();
        for (String columnId : columnIds) {
            if (columnId.contains(portletId)) continue;
            columnNames.add(String.valueOf(PortalUtil.getPortletNamespace((String)portletId)) + "_" + columnId);
        }
        return columnNames;
    }

    protected void reorganizeNestedColumns(ActionRequest actionRequest, String portletResource, String newLayoutTemplateId, String oldLayoutTemplateId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        Theme theme = themeDisplay.getTheme();
        LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)newLayoutTemplateId, (boolean)false, (String)theme.getThemeId());
        List<String> newColumns = this.getColumnNames(newLayoutTemplate.getContent(), portletResource);
        LayoutTemplate oldLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)oldLayoutTemplateId, (boolean)false, (String)theme.getThemeId());
        List<String> oldColumns = this.getColumnNames(oldLayoutTemplate.getContent(), portletResource);
        layoutTypePortlet.reorganizePortlets(newColumns, oldColumns);
        layoutTypePortlet.setStateMax("");
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

