/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.validhtml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ValidHtmlFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = String.valueOf(ValidHtmlFilter.class.getName()) + "SKIP_FILTER";
    private static final String _CLOSE_BODY = "</body>";
    private static final String _CLOSE_HTML = "</html>";
    private static Log _log = LogFactoryUtil.getLog(ValidHtmlFilter.class);

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return !this.isAlreadyFiltered(request);
    }

    protected String getContent(HttpServletRequest request, String content) {
        content = StringUtil.replaceLast((String)content, (String)_CLOSE_BODY, (String)"");
        content = StringUtil.replaceLast((String)content, (String)_CLOSE_HTML, (String)"</body></html>");
        return content;
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            _log.debug((Object)("Ensuring valid HTML " + completeURL));
        }
        BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
        this.processFilter(ValidHtmlFilter.class, request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
        String content = bufferCacheServletResponse.getString();
        String contentType = response.getContentType();
        if (contentType != null && contentType.startsWith("text/html")) {
            content = this.getContent(request, content);
            ServletResponseUtil.write((HttpServletResponse)response, (String)content);
        } else {
            ServletResponseUtil.write((HttpServletResponse)response, (BufferCacheServletResponse)bufferCacheServletResponse);
        }
    }
}

