/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.util.PortalUtil;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class PortalSessionAuthVerifier
implements AuthVerifier {
    public static final String AUTH_TYPE = PortalSessionAuthVerifier.class.getSimpleName();

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            HttpServletRequest request = accessControlContext.getRequest();
            User user = PortalUtil.getUser((HttpServletRequest)request);
            if (user == null) {
                return authVerifierResult;
            }
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(user.getUserId());
            return authVerifierResult;
        }
        catch (PortalException pe) {
            throw new AuthException((Throwable)pe);
        }
        catch (SystemException se) {
            throw new AuthException((Throwable)se);
        }
    }
}

