/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementInsert
extends StatementDML {
    int overrideUserValue = -1;

    StatementInsert(Session session, Table targetTable, int[] columnMap, Expression insertExpression, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.insertExpression = insertExpression;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
        this.isSimpleInsert = insertExpression != null && insertExpression.nodes.length == 1 && this.updatableTableCheck == null;
    }

    StatementInsert(Session session, Table targetTable, int[] columnMap, boolean[] checkColumns, QueryExpression queryExpression, ParserDQL.CompileContext compileContext, int override) {
        super(50, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.isTriggerInsertable() ? targetTable : targetTable.getBaseTable();
        this.insertColumnMap = columnMap;
        this.insertCheckColumns = checkColumns;
        this.queryExpression = queryExpression;
        this.overrideUserValue = override;
        this.setDatabseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.setupChecks();
    }

    Result getResult(Session session) {
        RowSetNavigator newDataNavigator;
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        PersistentStore store = this.baseTable.getRowStore(session);
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        if (this.isSimpleInsert) {
            Type[] colTypes = this.baseTable.getColumnTypes();
            Object[] data = this.getInsertData(session, colTypes, this.insertExpression.nodes[0].nodes);
            return this.insertSingleRow(session, store, data);
        }
        RowSetNavigator rowSetNavigator = newDataNavigator = this.queryExpression == null ? this.getInsertValuesNavigator(session) : this.getInsertSelectNavigator(session);
        if (newDataNavigator.getSize() > 0) {
            this.insertRowSet(session, generatedNavigator, newDataNavigator);
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, newDataNavigator);
        }
        if (resultOut == null) {
            resultOut = new Result(1, newDataNavigator.getSize());
        } else {
            resultOut.setUpdateCount(newDataNavigator.getSize());
        }
        return resultOut;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        int[] columnMap = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator nav = result.initialiseNavigator();
        Type[] sourceTypes = result.metaData.columnTypes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(2);
        while (nav.hasNext()) {
            Object[] data = this.baseTable.getNewRowData(session);
            Object[] sourceData = nav.getNext();
            for (int i = 0; i < columnMap.length; ++i) {
                int j = columnMap[i];
                if (j == this.overrideUserValue) continue;
                Type sourceType = sourceTypes[i];
                data[j] = colTypes[j].convertToType(session, sourceData[i], sourceType);
            }
            newData.add(data);
        }
        return newData;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] colTypes = this.baseTable.getColumnTypes();
        Expression[] list = this.insertExpression.nodes;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(list.length);
        for (int j = 0; j < list.length; ++j) {
            Expression[] rowArgs = list[j].nodes;
            Object[] data = this.getInsertData(session, colTypes, rowArgs);
            newData.add(data);
        }
        return newData;
    }
}

