/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.processors;

import java.util.List;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryParser.core.nodes.ParametricQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryParser.core.util.UnescapedCharSequence;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.nodes.WildcardQueryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowercaseExpandedTermsQueryNodeProcessor
extends QueryNodeProcessorImpl {
    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        Boolean lowercaseExpandedTerms = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.LOWERCASE_EXPANDED_TERMS);
        if (lowercaseExpandedTerms != null && lowercaseExpandedTerms.booleanValue()) {
            return super.process(queryTree);
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof WildcardQueryNode || node instanceof FuzzyQueryNode || node instanceof ParametricQueryNode) {
            FieldQueryNode fieldNode = (FieldQueryNode)node;
            fieldNode.setText(UnescapedCharSequence.toLowerCase(fieldNode.getText()));
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

