/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    private static final int[] defaultLimits = new int[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public int resultRangePosition;
    public boolean isValueList;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    Expression queryCondition;
    Expression checkQueryCondition;
    private Expression havingCondition;
    Expression rowExpression;
    Expression[] exprColumns;
    HsqlArrayList exprColumnList;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int groupByColumnCount;
    private int havingColumnCount;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean hasMemoryRow;
    public boolean isUniqueResultRows;
    private boolean simpleLimit = true;
    Type[] columnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    private OrderedHashSet conditionTables;
    public Index groupIndex;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean isValueList) {
        this(compileContext);
        this.isValueList = isValueList;
        RangeVariable range = new RangeVariable(table, null, null, null, compileContext);
        range.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(range);
        this.isMergeable = false;
        this.resolveReferences(session, RangeVariable.emptyArray);
        this.resolveTypes(session);
        this.sortAndSlice = SortAndSlice.noSort;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.compileContext = compileContext;
        this.resultRangePosition = compileContext.getNextRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isMergeable = true;
    }

    void addRangeVariable(RangeVariable rangeVar) {
        this.rangeVariableList.add(rangeVar);
    }

    private void resolveRangeVariables(Session session, RangeVariable[] outerRanges) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].resolveRangeTable(session, this.rangeVariables, i, outerRanges);
        }
    }

    void addSelectColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (e.opType == 97 && ((ExpressionColumn)e).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression first = (Expression)this.exprColumnList.get(0);
            if (first.opType == 97 && ((ExpressionColumn)first).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(e);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression e) {
        this.queryCondition = e;
    }

    void addGroupByColumnExpression(Expression e) {
        if (e.getType() == 25) {
            throw Error.error(5564);
        }
        this.exprColumnList.add(e);
        this.isGrouped = true;
        ++this.groupByColumnCount;
    }

    void addHavingExpression(Expression e) {
        this.exprColumnList.add(e);
        this.havingCondition = e;
        this.havingColumnCount = 1;
    }

    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    public void resolveReferences(Session session, RangeVariable[] outerRanges) {
        this.resolveRangeVariables(session, outerRanges);
        this.resolveColumnReferencesForAsterisk();
        this.finaliseColumns();
        this.resolveColumnReferences(session, outerRanges);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.setReferenceableColumns();
    }

    private void resolveColumnReferences(Session session, RangeVariable[] outerRanges) {
        int i;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Expression e = this.rangeVariables[i].getJoinCondition();
            if (e == null) continue;
            this.resolveColumnReferencesAndAllocate(session, e, i + 1, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, this.acceptsSequences);
        }
        for (i = this.indexLimitVisible; i < this.indexStartHaving; ++i) {
            this.exprColumns[i] = this.resolveColumnReferencesInGroupBy(session, this.exprColumns[i]);
        }
        for (i = this.indexStartHaving; i < this.indexStartOrderBy; ++i) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[i], this.rangeVariables.length, false);
        }
        this.resolveColumnRefernecesInOrderBy(session, outerRanges, this.sortAndSlice);
    }

    void resolveColumnRefernecesInOrderBy(Session session, RangeVariable[] outerRanges, SortAndSlice sortAndSlice) {
        int orderCount = sortAndSlice.getOrderLength();
        for (int i = 0; i < orderCount; ++i) {
            boolean check;
            ExpressionOrderBy e = (ExpressionOrderBy)sortAndSlice.exprList.get(i);
            this.replaceColumnIndexInOrderBy(e);
            if (e.getLeftNode().queryTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && e.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            e.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, e, this.rangeVariables.length, false);
            if (!this.isAggregated && !this.isGrouped || (check = e.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            sortAndSlice.limitCondition.resolveColumnReferences(session, outerRanges, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this);
    }

    private boolean resolveColumnReferences(Session session, Expression e, int rangeCount, boolean withSequences) {
        if (e == null) {
            return true;
        }
        int oldSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = e.resolveColumnReferences(session, this.rangeVariables, rangeCount, this.unresolvedExpressions, withSequences);
        int newSize = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return oldSize == newSize;
    }

    private void resolveColumnReferencesForAsterisk() {
        int pos = 0;
        while (pos < this.indexLimitVisible) {
            Expression e = (Expression)this.exprColumnList.get(pos);
            if (e.getType() == 97) {
                this.exprColumnList.remove(pos);
                String tablename = ((ExpressionColumn)e).getTableName();
                if (tablename == null) {
                    this.addAllJoinedColumns(e);
                } else {
                    int rangeIndex = e.findMatchingRangeVariableIndex(this.rangeVariables);
                    if (rangeIndex == -1) {
                        throw Error.error(5501, tablename);
                    }
                    RangeVariable range = this.rangeVariables[rangeIndex];
                    HashSet exclude = this.getAllNamedJoinColumns();
                    range.addTableColumns(e, exclude);
                }
                for (int i = 0; i < e.nodes.length; ++i) {
                    this.exprColumnList.add(pos, e.nodes[i]);
                    ++pos;
                }
                this.indexLimitVisible += e.nodes.length - 1;
                continue;
            }
            ++pos;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression, int count, boolean withSequences) {
        if (expression == null) {
            return;
        }
        HsqlList list = expression.resolveColumnReferences(session, this.rangeVariables, count, null, withSequences);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Expression e = (Expression)list.get(i);
                boolean resolved = true;
                if (e.isSelfAggregate()) {
                    for (int j = 0; j < e.nodes.length; ++j) {
                        HsqlList colList = e.nodes[j].resolveColumnReferences(session, this.rangeVariables, count, null, false);
                        resolved &= colList == null;
                    }
                } else {
                    resolved = this.resolveColumnReferences(session, e, count, withSequences);
                }
                if (resolved) {
                    if (e.isSelfAggregate()) {
                        if (this.aggregateSet == null) {
                            this.aggregateSet = new ArrayListIdentity();
                        }
                        this.aggregateSet.add(e);
                        this.isAggregated = true;
                        expression.setAggregate();
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(e);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(e);
            }
        }
    }

    private Expression resolveColumnReferencesInGroupBy(Session session, Expression expression) {
        if (expression == null) {
            return null;
        }
        HsqlList list = expression.resolveColumnReferences(session, this.rangeVariables, this.rangeVariables.length, null, false);
        if (list != null) {
            Expression resolved;
            if (expression.getType() == 2 && (resolved = expression.replaceAliasInOrderBy(this.exprColumns, this.indexLimitVisible)) != expression) {
                return resolved;
            }
            this.resolveColumnReferencesAndAllocate(session, expression, this.rangeVariables.length, false);
        }
        return expression;
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet set = null;
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            if (range.namedJoinColumns == null) continue;
            if (set == null) {
                set = new HashSet();
            }
            set.addAll(range.namedJoinColumns);
        }
        return set;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet nameSet, RangeVariable rightRange, boolean fullList) {
        HashSet set = new HashSet();
        Expression result = null;
        OrderedHashSet joinColumnNames = new OrderedHashSet();
        for (int i = 0; i < this.rangeVariableList.size(); ++i) {
            RangeVariable range = (RangeVariable)this.rangeVariableList.get(i);
            HashMappedList columnList = range.rangeTable.columnList;
            for (int j = 0; j < columnList.size(); ++j) {
                boolean repeated;
                ColumnSchema column = (ColumnSchema)columnList.get(j);
                String name = range.getColumnAlias(j);
                boolean columnInList = nameSet.contains(name);
                boolean namedJoin = range.namedJoinColumns != null && range.namedJoinColumns.contains(name);
                boolean bl = repeated = !namedJoin && !set.add(name);
                if (repeated && (!fullList || columnInList)) {
                    throw Error.error(5578, name);
                }
                if (!columnInList) continue;
                joinColumnNames.add(name);
                int leftPosition = range.rangeTable.getColumnIndex(column.getNameString());
                int rightPosition = rightRange.rangeTable.getColumnIndex(name);
                ExpressionLogical e = new ExpressionLogical(range, leftPosition, rightRange, rightPosition);
                result = ExpressionLogical.andExpressions(result, e);
                ExpressionColumn col = range.getColumnExpression(name);
                if (col == null) {
                    col = new ExpressionColumn(new Expression[]{e.getLeftNode(), e.getRightNode()}, name);
                    range.addNamedJoinColumnExpression(name, col);
                } else {
                    col.nodes = (Expression[])ArrayUtil.resizeArray(col.nodes, col.nodes.length + 1);
                    col.nodes[col.nodes.length - 1] = e.getRightNode();
                }
                rightRange.addNamedJoinColumnExpression(name, col);
            }
        }
        if (fullList && !joinColumnNames.containsAll(nameSet)) {
            throw Error.error(5501);
        }
        rightRange.addNamedJoinColumns(joinColumnNames);
        return result;
    }

    private void addAllJoinedColumns(Expression e) {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].addTableColumns(list);
        }
        Expression[] nodes = new Expression[list.size()];
        list.toArray(nodes);
        e.nodes = nodes;
    }

    private void finaliseColumns() {
        int i;
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        for (i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].queryTableColumnIndex = i;
        }
        if (this.sortAndSlice.hasOrder()) {
            for (i = 0; i < this.sortAndSlice.getOrderLength(); ++i) {
                this.exprColumns[this.indexStartOrderBy + i] = (Expression)this.sortAndSlice.exprList.get(i);
            }
        }
        this.rowExpression = new Expression(25, this.exprColumns);
    }

    private void replaceColumnIndexInOrderBy(Expression orderBy) {
        int i;
        Expression e = orderBy.getLeftNode();
        if (e.getType() != 1) {
            return;
        }
        if (e.getDataType().typeCode == 4 && 0 < (i = ((Integer)e.getValue(null)).intValue()) && i <= this.indexLimitVisible) {
            orderBy.setLeftNode(this.exprColumns[i - 1]);
            return;
        }
        throw Error.error(5576);
    }

    void collectRangeVariables(RangeVariable[] rangeVars, Set set) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectRangeVariables(rangeVars, set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectRangeVariables(rangeVars, set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectRangeVariables(rangeVars, set);
        }
    }

    public boolean hasReference(RangeVariable range) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.unresolvedExpressions.size(); ++i) {
            if (!((Expression)this.unresolvedExpressions.get(i)).hasReference(range)) continue;
            return true;
        }
        return false;
    }

    public void resolveExpressionTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            Expression e = this.exprColumns[i];
            e.resolveTypes(session, parent);
            if (e.getType() != 25) continue;
            throw Error.error(5564);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            Expression e = this.rangeVariables[i].getJoinCondition();
            if (e == null) continue;
            e.resolveTypes(session, null);
            if (e.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session, null);
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingCondition != null) {
            this.havingCondition.resolveTypes(session, null);
            if (this.havingCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int i = this.indexStartAggregates;
            int j = 0;
            while (i < this.indexLimitExpressions) {
                Expression e = (Expression)this.tempSet.get(j);
                this.exprColumns[i] = e.duplicate();
                this.exprColumns[i].nodes = e.nodes;
                this.exprColumns[i].dataType = e.dataType;
                ++i;
                ++j;
            }
            this.tempSet.clear();
        }
    }

    public boolean areColumnsResolved() {
        return this.unresolvedExpressions == null || this.unresolvedExpressions.isEmpty();
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeResolver = new RangeVariableResolver(this.rangeVariables, this.queryCondition, this.compileContext);
        rangeResolver.processConditions(session);
        this.rangeVariables = rangeResolver.rangeVariables;
        if (!this.isAggregated && (this.isDistinctSelect || this.isGrouped)) {
            RangeVariable range = null;
            this.tempSet.clear();
            for (int i = 0; i < this.indexLimitVisible; ++i) {
                if (this.exprColumns[i].getType() != 2) {
                    return;
                }
                if (i == 0) {
                    range = this.exprColumns[i].getRangeVariable();
                } else if (range != this.exprColumns[i].getRangeVariable()) {
                    return;
                }
                this.tempSet.add(this.exprColumns[i].getColumn().getName().name);
            }
            if (!range.hasIndexCondition()) {
                return;
            }
            int[] colMap = range.rangeTable.getColumnIndexes(this.tempSet);
            range.setDistinctColumnsOnIndex(colMap);
        }
    }

    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
    }

    void resolveTypesPartOne(Session session) {
        this.resolveExpressionTypes(session, this.rowExpression);
        this.resolveAggregates();
        for (int i = 0; i < this.unionColumnTypes.length; ++i) {
            this.unionColumnTypes[i] = Type.getAggregateType(this.unionColumnTypes[i], this.exprColumns[i].getDataType());
        }
    }

    void resolveTypesPartTwo(Session session) {
        int i;
        this.resolveGroups();
        for (i = 0; i < this.unionColumnTypes.length; ++i) {
            Type type = this.unionColumnTypes[i];
            if (type == null) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[i] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[i].setDataType(session, type);
        }
        for (i = 0; i < this.indexStartHaving; ++i) {
            if (this.exprColumns[i].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability();
        this.createResultMetaData();
        this.createTable(session);
        if (this.isMergeable) {
            this.mergeQuery();
        }
        this.setRangeVariableConditions(session);
        if (this.isAggregated && !this.isGrouped && !this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression e = this.exprColumns[this.indexStartAggregates];
            int opType = e.getType();
            switch (opType) {
                case 73: 
                case 74: {
                    if (e.hasCondition()) break;
                    SortAndSlice slice = new SortAndSlice();
                    slice.isGenerated = true;
                    slice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!slice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = slice;
                    break;
                }
                case 71: {
                    if (e.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null || e.getLeftNode().getType() != 10) break;
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
        this.sortAndSlice.setSortRange(this);
        this.isResolved = true;
    }

    void checkLobUsage() {
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        for (int i = 0; i < this.indexStartHaving; ++i) {
            if (!this.exprColumns[i].dataType.isLobType()) continue;
            throw Error.error(5534);
        }
    }

    private void resolveGroups() {
        Expression e;
        int i;
        ExpressionColumn c;
        Expression e2;
        int i2;
        Expression e3;
        int i3;
        int orderCount;
        int i4;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                this.exprColumns[i4].collectAllExpressions(this.tempSet, Expression.aggregateFunctionSet, Expression.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                if (this.exprColumns[i4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, Expression.subqueryAggregateExpressionSet)) continue;
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.tempSet.isEmpty() && !this.resolveForGroupBy(this.tempSet)) {
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        } else if (this.isAggregated) {
            for (i4 = 0; i4 < this.indexLimitVisible; ++i4) {
                this.exprColumns[i4].collectAllExpressions(this.tempSet, Expression.columnExpressionSet, Expression.aggregateFunctionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
            }
        }
        this.tempSet.clear();
        if (this.havingCondition != null) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (i4 = this.indexLimitVisible; i4 < this.indexLimitVisible + this.groupByColumnCount; ++i4) {
                this.tempSet.add(this.exprColumns[i4]);
            }
            if (!this.havingCondition.isComposedOf(this.tempSet, Expression.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            orderCount = this.sortAndSlice.getOrderLength();
            for (i3 = 0; i3 < orderCount; ++i3) {
                e3 = (Expression)this.sortAndSlice.exprList.get(i3);
                if (e3.queryTableColumnIndex != -1 || e3.isAggregate() || e3.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, Expression.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isDistinctSelect || this.isGrouped) {
            this.simpleLimit = false;
        }
        if (!this.isAggregated) {
            return;
        }
        OrderedHashSet expressions = new OrderedHashSet();
        OrderedHashSet columnExpressions = new OrderedHashSet();
        for (i2 = this.indexStartAggregates; i2 < this.indexLimitExpressions; ++i2) {
            e2 = this.exprColumns[i2];
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            expressions.add(e2);
            columnExpressions.add(c);
        }
        for (i2 = 0; i2 < this.indexStartHaving; ++i2) {
            if (this.exprColumns[i2].isAggregate() || !expressions.add(e2 = this.exprColumns[i2])) continue;
            c = new ExpressionColumn(e2, i2, this.resultRangePosition);
            columnExpressions.add(c);
        }
        int orderCount2 = this.sortAndSlice.getOrderLength();
        for (i = 0; i < orderCount2; ++i) {
            e = (Expression)this.sortAndSlice.exprList.get(i);
            if (!e.getLeftNode().isAggregate()) continue;
            e.setAggregate();
        }
        for (i = this.indexStartOrderBy; i < this.indexStartAggregates; ++i) {
            if (!this.exprColumns[i].getLeftNode().isAggregate()) continue;
            this.exprColumns[i].setAggregate();
        }
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            if (!e.isAggregate() && !e.isCorrelated()) continue;
            this.aggregateCheck[i] = true;
            if (!e.isAggregate()) continue;
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        for (i = 0; i < this.aggregateSet.size(); ++i) {
            e = (Expression)this.aggregateSet.get(i);
            e.convertToSimpleColumn(expressions, columnExpressions);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (i = 0; i < this.resolvedSubqueryExpressions.size(); ++i) {
                e = (Expression)this.resolvedSubqueryExpressions.get(i);
                e.convertToSimpleColumn(expressions, columnExpressions);
            }
        }
    }

    boolean resolveForGroupBy(HsqlList unresolvedSet) {
        int i;
        for (i = this.indexLimitVisible; i < this.indexLimitVisible + this.groupByColumnCount; ++i) {
            Expression e = this.exprColumns[i];
            if (e.getType() != 2) continue;
            RangeVariable range = e.getRangeVariable();
            int colIndex = e.getColumnIndex();
            range.columnsInGroupBy[colIndex] = true;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            range.hasKeyedColumnInGroupBy = range.rangeTable.getUniqueNotNullColumnGroup(range.columnsInGroupBy) != null;
        }
        OrderedHashSet set = null;
        for (int i2 = 0; i2 < unresolvedSet.size(); ++i2) {
            Expression e = (Expression)unresolvedSet.get(i2);
            set = e.getUnkeyedColumns(set);
        }
        return set == null;
    }

    int[] getLimits(Session session, int maxRows) {
        int[] nArray;
        int skipRows = 0;
        int limitRows = Integer.MAX_VALUE;
        int limitFetch = Integer.MAX_VALUE;
        boolean hasLimits = false;
        if (this.sortAndSlice.hasLimit()) {
            Integer value = (Integer)this.sortAndSlice.limitCondition.getLeftNode().getValue(session);
            if (value == null || value < 0) {
                throw Error.error(3453);
            }
            skipRows = value;
            boolean bl = hasLimits = skipRows != 0;
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                value = (Integer)this.sortAndSlice.limitCondition.getRightNode().getValue(session);
                if (value == null || value < 0 || this.sortAndSlice.strictLimit && value == 0) {
                    throw Error.error(3452);
                }
                if (value == 0) {
                    limitRows = Integer.MAX_VALUE;
                } else {
                    limitRows = value;
                    hasLimits = true;
                }
            }
        }
        if (maxRows != 0) {
            if (maxRows < limitRows) {
                limitRows = maxRows;
            }
            hasLimits = true;
        }
        if (hasLimits && this.simpleLimit && (!this.sortAndSlice.hasOrder() || this.sortAndSlice.skipSort) && (!this.sortAndSlice.hasLimit() || this.sortAndSlice.skipFullResult) && limitFetch - skipRows > limitRows) {
            limitFetch = skipRows + limitRows;
        }
        if (hasLimits) {
            int[] nArray2 = new int[3];
            nArray2[0] = skipRows;
            nArray2[1] = limitRows;
            nArray = nArray2;
            nArray2[2] = limitFetch;
        } else {
            nArray = defaultLimits;
        }
        return nArray;
    }

    Result getResult(Session session, int maxrows) {
        Result r = this.getSingleResult(session, maxrows);
        r.getNavigator().reset();
        return r;
    }

    private Result getSingleResult(Session session, int maxRows) {
        int[] limits = this.getLimits(session, maxRows);
        Result r = this.buildResult(session, limits[2]);
        RowSetNavigatorData navigator = (RowSetNavigatorData)r.getNavigator();
        if (this.isDistinctSelect) {
            navigator.removeDuplicates(session);
        }
        if (this.sortAndSlice.hasOrder()) {
            navigator.sortOrder(session);
        }
        if (limits != defaultLimits) {
            navigator.trim(limits[0], limits[1]);
        }
        return r;
    }

    private Result buildResult(Session session, int limitcount) {
        int i;
        RowSetNavigatorData navigator = new RowSetNavigatorData(session, this);
        Result result = Result.newResult(navigator);
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        if (this.isSimpleCount) {
            Object[] data = new Object[this.indexLimitData];
            Table table = this.rangeVariables[0].getTable();
            PersistentStore store = table.getRowStore(session);
            int count = store.elementCount(session);
            data[0] = data[this.indexStartAggregates] = ValuePool.getInt(count);
            navigator.add(data);
            return result;
        }
        int fullJoinIndex = 0;
        RangeIterator[] rangeIterators = new RangeIterator[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i] = this.rangeVariables[i].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        int currentIndex = 0;
        while (true) {
            int i2;
            RangeIterator it;
            if (currentIndex < fullJoinIndex) {
                boolean end = true;
                for (int i3 = fullJoinIndex + 1; i3 < this.rangeVariables.length; ++i3) {
                    if (!this.rangeVariables[i3].isRightJoin) continue;
                    fullJoinIndex = i3;
                    currentIndex = i3;
                    end = false;
                    ((RangeVariable.RangeIteratorRight)rangeIterators[i3]).setOnOuterRows();
                    break;
                }
                if (end) break;
            }
            if ((it = rangeIterators[currentIndex]).next()) {
                if (currentIndex < this.rangeVariables.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                it.reset();
                --currentIndex;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] data = new Object[this.indexLimitData];
            for (i2 = 0; i2 < this.indexStartAggregates; ++i2) {
                if (this.isAggregated && this.aggregateCheck[i2]) continue;
                data[i2] = this.exprColumns[i2].getValue(session);
            }
            for (i2 = this.indexLimitVisible; i2 < this.indexLimitRowId; ++i2) {
                data[i2] = i2 == this.indexLimitVisible ? it.getRowidObject() : it.getCurrentRow();
            }
            ++session.sessionContext.rownum;
            Object[] groupData = null;
            if ((this.isAggregated || this.isGrouped) && (groupData = navigator.getGroupData(data)) != null) {
                data = groupData;
            }
            for (int i4 = this.indexStartAggregates; i4 < this.indexLimitExpressions; ++i4) {
                data[i4] = this.exprColumns[i4].updateAggregatingValue(session, data[i4]);
            }
            if (groupData == null) {
                navigator.add(data);
            } else if (this.isAggregated) {
                navigator.update(groupData, data);
            }
            int rowCount = navigator.getSize();
            if (rowCount == session.resultMaxMemoryRows && !this.isAggregated && !this.hasMemoryRow) {
                navigator = new RowSetNavigatorDataTable(session, this, navigator);
                result.setNavigator(navigator);
            }
            if ((!this.isAggregated && !this.isGrouped || this.sortAndSlice.isGenerated) && rowCount >= limitcount) break;
        }
        navigator.reset();
        for (i = 0; i < this.rangeVariables.length; ++i) {
            rangeIterators[i].reset();
        }
        if (!this.isGrouped && !this.isAggregated) {
            return result;
        }
        if (this.isAggregated) {
            if (!this.isGrouped && navigator.getSize() == 0) {
                Object[] data = new Object[this.exprColumns.length];
                navigator.add(data);
            }
            navigator.reset();
            session.sessionContext.setRangeIterator(navigator);
            while (navigator.next()) {
                int i5;
                Object[] data = navigator.getCurrent();
                for (i5 = this.indexStartAggregates; i5 < this.indexLimitExpressions; ++i5) {
                    data[i5] = this.exprColumns[i5].getAggregatedValue(session, data[i5]);
                }
                for (i5 = 0; i5 < this.indexStartAggregates; ++i5) {
                    if (!this.aggregateCheck[i5]) continue;
                    data[i5] = this.exprColumns[i5].getValue(session);
                }
            }
        }
        navigator.reset();
        if (this.havingCondition != null) {
            while (navigator.hasNext()) {
                Object[] data = navigator.getNext();
                if (Boolean.TRUE.equals(data[this.indexLimitVisible + this.groupByColumnCount])) continue;
                navigator.remove();
            }
            navigator.reset();
        }
        return result;
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap aliases = new IntValueHashMap();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression expression = this.exprColumns[i];
            String alias = expression.getAlias();
            if (alias.length() == 0) {
                HsqlNameManager.HsqlName name = HsqlNameManager.getAutoColumnName(i);
                expression.setAlias(name);
                continue;
            }
            int index = aliases.get((Object)alias, -1);
            if (index == -1) {
                aliases.put(alias, i);
                this.accessibleColumns[i] = true;
                continue;
            }
            this.accessibleColumns[index] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] names) {
        if (names.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            this.exprColumns[i].setAlias(names[i]);
        }
    }

    private void createResultMetaData() {
        Expression e;
        int i;
        this.columnTypes = new Type[this.indexLimitData];
        for (i = 0; i < this.indexStartAggregates; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        for (i = this.indexLimitVisible; i < this.indexLimitRowId; ++i) {
            this.columnTypes[i] = i == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (i = this.indexLimitRowId; i < this.indexLimitData; ++i) {
            e = this.exprColumns[i];
            this.columnTypes[i] = e.getDataType();
        }
        this.resultMetaData = ResultMetaData.newResultMetaData(this.columnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (i = 0; i < this.indexLimitVisible; ++i) {
            e = this.exprColumns[i];
            this.resultMetaData.columnTypes[i] = e.getDataType();
            if (i >= this.indexLimitVisible) continue;
            ColumnBase column = e.getColumn();
            if (column != null) {
                this.resultMetaData.columns[i] = column;
                this.resultMetaData.columnLabels[i] = e.getAlias();
                continue;
            }
            column = new ColumnBase();
            column.setType(e.getDataType());
            this.resultMetaData.columns[i] = column;
            this.resultMetaData.columnLabels[i] = e.getAlias();
        }
    }

    void createTable(Session session) {
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            int[] groupCols = new int[this.groupByColumnCount];
            for (int i = 0; i < this.groupByColumnCount; ++i) {
                groupCols[i] = this.indexLimitVisible + i;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, groupCols, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            int[] idCols = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, idCols, null, null, false, false, false);
        }
    }

    void createFullIndex(Session session) {
        int[] fullCols = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(fullCols);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, fullCols, null, null, false, false, false);
    }

    void createResultTable(Session session) {
        HsqlNameManager.HsqlName tableName = session.database.nameManager.getSubqueryTableName();
        int tableType = this.persistenceScope == 21 ? 2 : 9;
        HashMappedList columnList = new HashMappedList();
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            Expression e = this.exprColumns[i];
            HsqlNameManager.SimpleName simpleName = e.getSimpleName();
            String nameString = simpleName.name;
            HsqlNameManager.HsqlName name = session.database.nameManager.newColumnSchemaHsqlName(tableName, simpleName);
            if (!this.accessibleColumns[i]) {
                nameString = HsqlNameManager.getAutoNoNameColumnString(i);
            }
            ColumnSchema column = new ColumnSchema(name, e.dataType, true, false, null);
            columnList.add(nameString, column);
        }
        try {
            this.resultTable = new TableDerived(session.database, tableName, tableType, this.columnTypes, columnList, null, null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getSQL() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        int limit = this.indexLimitVisible;
        for (i = 0; i < limit; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exprColumns[i].getSQL());
        }
        sb.append("FROM");
        limit = this.rangeVariables.length;
        for (i = 0; i < limit; ++i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            if (i > 0) {
                if (rangeVar.isLeftJoin && rangeVar.isRightJoin) {
                    sb.append("FULL").append(' ');
                } else if (rangeVar.isLeftJoin) {
                    sb.append("LEFT").append(' ');
                } else if (rangeVar.isRightJoin) {
                    sb.append("RIGHT").append(' ');
                }
                sb.append("JOIN").append(' ');
            }
            sb.append(rangeVar.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            sb.append(' ').append("GROUP").append(' ').append("BY");
            limit = this.indexLimitVisible + this.groupByColumnCount;
            for (i = this.indexLimitVisible; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.havingCondition != null) {
            sb.append(' ').append("HAVING").append(' ');
            sb.append(this.havingCondition.getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            limit = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            sb.append(' ').append("ORDER").append("BY").append(' ');
            for (i = this.indexStartOrderBy; i < limit; ++i) {
                sb.append(this.exprColumns[i].getSQL());
                if (i >= limit - 1) continue;
                sb.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            sb.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return sb.toString();
    }

    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    public String describe(Session session, int blanks) {
        String temp;
        int index;
        int i;
        String b = ValuePool.spaceString.substring(0, blanks);
        StringBuffer sb = new StringBuffer();
        sb.append(b).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append(b).append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append(b).append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append(b).append("columns=[");
        for (i = 0; i < this.indexLimitVisible; ++i) {
            index = i;
            if (this.exprColumns[i].getType() == 5) {
                index = this.exprColumns[i].columnIndex;
            }
            sb.append(b).append(this.exprColumns[index].describe(session, 2));
        }
        sb.append("\n");
        sb.append(b).append("]\n");
        for (i = 0; i < this.rangeVariables.length; ++i) {
            sb.append(b).append("[");
            sb.append("range variable ").append(i + 1).append("\n");
            sb.append(this.rangeVariables[i].describe(session, blanks + 2));
            sb.append(b).append("]");
        }
        sb.append(b).append("]\n");
        String string = temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session, blanks);
        if (this.isGrouped) {
            sb.append(b).append("groupColumns=[");
            for (i = this.indexLimitRowId; i < this.indexLimitRowId + this.groupByColumnCount; ++i) {
                index = i;
                if (this.exprColumns[i].getType() == 5) {
                    index = this.exprColumns[i].columnIndex;
                }
                sb.append(this.exprColumns[index].describe(session, blanks));
            }
            sb.append(b).append("]\n");
        }
        if (this.havingCondition != null) {
            temp = this.havingCondition.describe(session, blanks);
            sb.append(b).append("havingCondition=[").append(temp).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            sb.append(b).append("order by=[\n");
            for (i = 0; i < this.sortAndSlice.exprList.size(); ++i) {
                sb.append(b).append(((Expression)this.sortAndSlice.exprList.get(i)).describe(session, blanks));
                sb.append(b).append("\n]");
            }
            sb.append(b).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                sb.append(b).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, 0)).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                sb.append(b).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, 0)).append("]\n");
            }
        }
        return sb.toString();
    }

    void setMergeability() {
        if (this.isGrouped || this.isDistinctSelect) {
            this.isMergeable = false;
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            this.isMergeable = false;
            return;
        }
        if (this.rangeVariables.length != 1) {
            this.isMergeable = false;
            return;
        }
    }

    void setUpdatability() {
        String name;
        Expression expression;
        int i;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (!this.isMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        if (this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) {
            return;
        }
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Table baseTable = table.getBaseTable();
        if (baseTable == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap columns = new IntValueHashMap();
        int[] baseColumnMap = table.getBaseTableColumnMap();
        int[] columnMap = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(baseTable.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (i = 0; i < this.indexLimitVisible; ++i) {
            expression = this.exprColumns[i];
            if (expression.getType() == 2) {
                name = expression.getColumn().getName().name;
                if (columns.containsKey(name)) {
                    columns.put(name, 1);
                    continue;
                }
                columns.put(name, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, expression);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (i = 0; i < this.indexLimitVisible; ++i) {
            if (this.accessibleColumns[i] && (expression = this.exprColumns[i]).getType() == 2 && columns.get(name = expression.getColumn().getName().name) == 0) {
                int index = table.findColumn(name);
                columnMap[i] = baseColumnMap[index];
                if (columnMap[i] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            columnMap[i] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] checkList = baseTable.getColumnCheckList(columnMap);
            for (i = 0; i < checkList.length; ++i) {
                ColumnSchema column;
                if (checkList[i] || (column = baseTable.getColumn(i)).isIdentity() || column.isGenerated() || column.hasDefault() || column.isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = columnMap;
            this.baseTable = baseTable;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!baseTable.isFileBased()) {
                ++this.indexLimitRowId;
                this.hasMemoryRow = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery() {
        RangeVariable rangeVar = this.rangeVariables[0];
        Table table = rangeVar.getTable();
        Expression localQueryCondition = this.queryCondition;
        if (table instanceof TableDerived) {
            QueryExpression baseQueryExpression = ((TableDerived)table).getQueryExpression();
            if (baseQueryExpression == null || !baseQueryExpression.isMergeable) {
                this.isMergeable = false;
                return;
            }
            QuerySpecification baseSelect = baseQueryExpression.getMainSelect();
            if (baseQueryExpression.view == null) {
                this.rangeVariables[0] = baseSelect.rangeVariables[0];
                this.rangeVariables[0].resetConditions();
                Expression[] newExprColumns = new Expression[this.indexLimitData];
                for (int i = 0; i < this.indexLimitData; ++i) {
                    Expression e = this.exprColumns[i];
                    newExprColumns[i] = e.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
                }
                this.exprColumns = newExprColumns;
                if (localQueryCondition != null) {
                    localQueryCondition = localQueryCondition.replaceColumnReferences(rangeVar, baseSelect.exprColumns);
                }
                Expression baseQueryCondition = baseSelect.queryCondition;
                this.checkQueryCondition = baseSelect.checkQueryCondition;
                this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
            } else {
                Expression e;
                int i;
                RangeVariable[] newRangeVariables = new RangeVariable[]{baseSelect.rangeVariables[0].duplicate()};
                Expression[] newBaseExprColumns = new Expression[baseSelect.indexLimitData];
                for (i = 0; i < baseSelect.indexLimitData; ++i) {
                    newBaseExprColumns[i] = e = baseSelect.exprColumns[i].duplicate();
                    e.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                for (i = 0; i < this.indexLimitData; ++i) {
                    e = this.exprColumns[i];
                    this.exprColumns[i] = e.replaceColumnReferences(rangeVar, newBaseExprColumns);
                }
                Expression baseQueryCondition = baseSelect.queryCondition;
                if (baseQueryCondition != null) {
                    baseQueryCondition = baseQueryCondition.duplicate();
                    baseQueryCondition.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                if (localQueryCondition != null) {
                    localQueryCondition = localQueryCondition.replaceColumnReferences(rangeVar, newBaseExprColumns);
                }
                this.checkQueryCondition = baseSelect.checkQueryCondition;
                if (this.checkQueryCondition != null) {
                    this.checkQueryCondition = this.checkQueryCondition.duplicate();
                    this.checkQueryCondition.replaceRangeVariables(baseSelect.rangeVariables, newRangeVariables);
                }
                this.queryCondition = ExpressionLogical.andExpressions(baseQueryCondition, localQueryCondition);
                this.rangeVariables = newRangeVariables;
            }
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = localQueryCondition;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet set, Expression expression) {
        expression.collectAllExpressions(set, Expression.subqueryExpressionSet, Expression.emptyExpressionSet);
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            Expression e = (Expression)set.get(i);
            e.collectObjectNames(set);
        }
    }

    public OrderedHashSet getSubqueries() {
        int i;
        OrderedHashSet set = null;
        for (i = 0; i < this.indexLimitExpressions; ++i) {
            set = this.exprColumns[i].collectAllSubqueries(set);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllSubqueries(set);
        }
        if (this.havingCondition != null) {
            set = this.havingCondition.collectAllSubqueries(set);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            OrderedHashSet temp = this.rangeVariables[i].getSubqueries();
            set = OrderedHashSet.addAll(set, temp);
        }
        return set;
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectAllSubqueries(OrderedHashSet set) {
        return set;
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        for (int i = 0; i < this.indexStartAggregates; ++i) {
            set = this.exprColumns[i].collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (this.queryCondition != null) {
            set = this.queryCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        if (this.havingCondition != null) {
            set = this.havingCondition.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    public void collectObjectNames(Set set) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        if (this.havingCondition != null) {
            this.havingCondition.collectObjectNames(set);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            HsqlNameManager.HsqlName name = this.rangeVariables[i].getTable().getName();
            set.add(name);
        }
    }

    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].replaceColumnReferences(range, list);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceColumnReferences(range, list);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceColumnReferences(range, list);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
        }
    }

    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.indexStartAggregates; ++i) {
            this.exprColumns[i].replaceRangeVariables(ranges, newRanges);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(ranges, newRanges);
        }
        if (this.havingCondition != null) {
            this.havingCondition.replaceRangeVariables(ranges, newRanges);
        }
        int len = this.rangeVariables.length;
        for (i = 0; i < len; ++i) {
            this.rangeVariables[i].getSubqueries();
        }
    }

    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    public String[] getColumnNames() {
        String[] names = new String[this.indexLimitVisible];
        for (int i = 0; i < this.indexLimitVisible; ++i) {
            names[i] = this.exprColumns[i].getAlias();
        }
        return names;
    }

    public Type[] getColumnTypes() {
        if (this.columnTypes.length == this.indexLimitVisible) {
            return this.columnTypes;
        }
        Type[] types = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.columnTypes, types, types.length);
        return types;
    }

    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    void getBaseTableNames(OrderedHashSet set) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
    }

    boolean isEquivalent(QueryExpression other) {
        if (!(other instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification otherSpec = (QuerySpecification)other;
        if (!Expression.equals(this.exprColumns, otherSpec.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, otherSpec.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != otherSpec.rangeVariables.length) {
            return false;
        }
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].getTable() == otherSpec.rangeVariables[i].getTable()) continue;
            return false;
        }
        return true;
    }
}

