/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jamwiki.utils.WikiLogger;

public class TiddlyWiki2MediaWikiTranslator {
    private static final WikiLogger logger = WikiLogger.getLogger(TiddlyWiki2MediaWikiTranslator.class.getName());
    public static String newline = System.getProperty("line.separator");

    public String translate(String wikicode) throws IOException {
        String replaced = wikicode.replaceAll("\\\\n", "\n");
        replaced = this.insertBreaks(replaced);
        logger.info("Content with breaks?:  " + replaced);
        replaced = this.tables(this.headers(this.wikiLinks(replaced)));
        return replaced;
    }

    private String tables(String wikicode) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(wikicode));
        StringBuilder output = new StringBuilder();
        boolean inTable = false;
        String line = reader.readLine();
        while (line != null) {
            if (inTable) {
                if (line.charAt(0) == '|') {
                    output.append("|-");
                    output.append(newline);
                    output.append(this.translateTableLine(line));
                } else {
                    output.append("|}");
                    output.append(newline);
                    output.append(line);
                    inTable = false;
                }
            } else if (line.charAt(0) == '|') {
                output.append("{|");
                output.append(newline);
                inTable = true;
                output.append(this.translateTableLine(line));
            } else {
                output.append(line);
            }
            if ((line = reader.readLine()) == null) continue;
            output.append(newline);
        }
        if (inTable) {
            output.append(newline);
            output.append("|}");
        }
        return output.toString();
    }

    private String translateTableLine(String line) {
        String[] tokens = line.split("\\|");
        StringBuilder output = new StringBuilder();
        output.append('|');
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                output.append("||");
            }
            if (token.charAt(0) == '!') {
                output.append("'''");
            }
            output.append(token);
            if (token.charAt(0) != '!') continue;
            output.append("'''");
        }
        return output.toString();
    }

    private String headers(String wikicode) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(wikicode));
        String line = null;
        StringBuilder output = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            int i;
            for (i = 0; line.length() > i && line.charAt(i) == '!'; ++i) {
                output.append('=');
            }
            output.append(line.substring(i));
            for (int j = 0; j < i; ++j) {
                output.append('=');
            }
            output.append(newline);
        }
        return output.toString();
    }

    public String wikiLinks(String wikicode) {
        StringBuilder output = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(wikicode, " \t\n\r\f<>", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() > 0 && Character.isUpperCase(token.charAt(0))) {
                String rest = token.substring(1);
                if (!rest.toLowerCase().equals(rest)) {
                    output.append("[[");
                    output.append(token);
                    output.append("]]");
                    continue;
                }
                output.append(token);
                continue;
            }
            output.append(token);
        }
        return output.toString();
    }

    public String insertBreaks(String wikicode) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(wikicode));
        StringBuilder output = new StringBuilder();
        boolean isLetterLast = false;
        boolean isLetterNow = false;
        String line = reader.readLine();
        String lastLine = null;
        while (line != null) {
            isLetterLast = isLetterNow;
            isLetterNow = line != null && line.length() > 0 && Character.isLetterOrDigit(line.charAt(0));
            if (lastLine != null) {
                output.append(lastLine);
            }
            if (isLetterLast && isLetterNow) {
                output.append("<br/>");
            }
            if (lastLine != null) {
                output.append(newline);
            }
            lastLine = line;
            line = reader.readLine();
            if (line != null) continue;
            output.append(lastLine);
        }
        return output.toString();
    }
}

