/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlTester {
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final XPathFactory xpathf = XPathFactory.newInstance();
    static final DocumentBuilder db;
    final Document document;
    final XPath xpath = xpathf.newXPath();

    public XmlTester(InputStream in, final String ... namespace) throws Exception {
        this.xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return Arrays.asList("md", "scr").iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                for (int i = 0; i < namespace.length; i += 2) {
                    if (!namespaceURI.equals(namespace[i + 1])) continue;
                    return namespace[i];
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                for (int i = 0; i < namespace.length; i += 2) {
                    if (!prefix.equals(namespace[i])) continue;
                    return namespace[i + 1];
                }
                return null;
            }
        });
        this.document = db.parse(in);
    }

    public void assertAttribute(String value, String expr) throws XPathExpressionException {
        System.err.println(expr);
        String o = (String)this.xpath.evaluate(expr, this.document, XPathConstants.STRING);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)value, (String)o);
    }

    public void assertNamespace(String namespace) {
        Element element = this.document.getDocumentElement();
        String xmlns = element.getNamespaceURI();
        Assert.assertEquals((String)namespace, (String)xmlns);
    }

    static {
        try {
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

