/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;

public class StringTemplateResource
implements TemplateResource {
    private long _lastModified = System.currentTimeMillis();
    private String _templateContent;
    private String _templateId;

    public StringTemplateResource() {
    }

    public StringTemplateResource(String templateId, String templateContent) {
        if (Validator.isNull(templateId)) {
            throw new IllegalArgumentException("Template ID is null");
        }
        if (Validator.isNull(templateContent)) {
            throw new IllegalArgumentException("Template content is null");
        }
        this._templateId = templateId;
        this._templateContent = templateContent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringTemplateResource)) {
            return false;
        }
        StringTemplateResource stringTemplateResource = (StringTemplateResource)obj;
        return this._templateId.equals(stringTemplateResource._templateId) && this._templateContent.equals(stringTemplateResource._templateContent);
    }

    public String getContent() {
        return this._templateContent;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public Reader getReader() {
        return new UnsyncStringReader(this._templateContent);
    }

    @Override
    public String getTemplateId() {
        return this._templateId;
    }

    public int hashCode() {
        return this._templateId.hashCode() * 11 + this._templateContent.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this._lastModified = objectInput.readLong();
        this._templateContent = objectInput.readUTF();
        this._templateId = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this._lastModified);
        objectOutput.writeUTF(this._templateContent);
        objectOutput.writeUTF(this._templateId);
    }
}

