/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.concurrent.CompeteLatch;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BlockingPortalCache<K extends Serializable, V>
implements PortalCache<K, V> {
    private static ThreadLocal<CompeteLatch> _competeLatch = new ThreadLocal();
    private final ConcurrentMap<K, CompeteLatch> _competeLatchMap = new ConcurrentHashMap<K, CompeteLatch>();
    private final PortalCache<K, V> _portalCache;

    public BlockingPortalCache(PortalCache<K, V> portalCache) {
        this._portalCache = portalCache;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Collection<V> get(Collection<K> keys) {
        return this._portalCache.get(keys);
    }

    @Override
    public V get(K key) {
        CompeteLatch newCompeteLatch;
        CompeteLatch currentCompeteLatch;
        V value = this._portalCache.get(key);
        if (value != null) {
            return value;
        }
        CompeteLatch lastCompeteLatch = _competeLatch.get();
        if (lastCompeteLatch != null) {
            lastCompeteLatch.done();
            _competeLatch.set(null);
        }
        if ((currentCompeteLatch = (CompeteLatch)this._competeLatchMap.get(key)) == null && (currentCompeteLatch = this._competeLatchMap.putIfAbsent(key, newCompeteLatch = new CompeteLatch())) == null) {
            currentCompeteLatch = newCompeteLatch;
        }
        _competeLatch.set(currentCompeteLatch);
        if (!currentCompeteLatch.compete()) {
            try {
                currentCompeteLatch.await();
            }
            catch (InterruptedException interruptedException) {}
            _competeLatch.set(null);
            value = this._portalCache.get(key);
        }
        return value;
    }

    @Override
    public List<K> getKeys() {
        return this._portalCache.getKeys();
    }

    @Override
    public String getName() {
        return this._portalCache.getName();
    }

    @Override
    public void put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        this._portalCache.put(key, value);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        this._portalCache.put(key, value, timeToLive);
        CompeteLatch competeLatch = _competeLatch.get();
        if (competeLatch != null) {
            competeLatch.done();
            _competeLatch.set(null);
        }
        this._competeLatchMap.remove(key);
    }

    @Override
    public void registerCacheListener(CacheListener<K, V> cacheListener) {
        this._portalCache.registerCacheListener(cacheListener);
    }

    @Override
    public void registerCacheListener(CacheListener<K, V> cacheListener, CacheListenerScope cacheListenerScope) {
        this._portalCache.registerCacheListener(cacheListener, cacheListenerScope);
    }

    @Override
    public void remove(K key) {
        this._portalCache.remove(key);
        CompeteLatch competeLatch = (CompeteLatch)this._competeLatchMap.remove(key);
        if (competeLatch != null) {
            competeLatch.done();
        }
    }

    @Override
    public void removeAll() {
        this._portalCache.removeAll();
        this._competeLatchMap.clear();
    }

    @Override
    public void unregisterCacheListener(CacheListener<K, V> cacheListener) {
        this._portalCache.unregisterCacheListener(cacheListener);
    }

    @Override
    public void unregisterCacheListeners() {
        this._portalCache.unregisterCacheListeners();
    }
}

