/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import aQute.bnd.osgi.Analyzer;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ManifestHelperTask
extends Task {
    private static final String _PATTERN = "EEE MMM d HH:mm:ss z yyyy";
    private boolean _analyze;
    private Path _path;
    private String _projectDirPropertyName;

    public void execute() throws BuildException {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setAnalyze(boolean analyze) {
        this._analyze = analyze;
    }

    public void setClasspathRef(Reference reference) {
        if (this._path == null) {
            this._path = new Path(this.getProject());
        }
        Path path = this._path.createPath();
        path.setRefid(reference);
    }

    public void setProjectDirPropertyName(String projectDirPropertyName) {
        this._projectDirPropertyName = projectDirPropertyName;
    }

    protected void doExecute() throws Exception {
        if (this._projectDirPropertyName == null) {
            throw new BuildException("Attribute projectDirPropertyName must be set");
        }
        Project project = this.getProject();
        project.setProperty("build.revision", this.getBuildRevision());
        project.setProperty("build.time", this.getDateString(new Date()));
        project.setProperty("release.info.build.date", String.valueOf(ReleaseInfo.getBuildDate()));
        project.setProperty("release.info.build.number", String.valueOf(ReleaseInfo.getBuildNumber()));
        project.setProperty("release.info.code.name", ReleaseInfo.getCodeName());
        project.setProperty("release.info.parent.build.number", String.valueOf(ReleaseInfo.getParentBuildNumber()));
        project.setProperty("release.info.release.info", ReleaseInfo.getReleaseInfo());
        project.setProperty("release.info.server.info", ReleaseInfo.getServerInfo());
        project.setProperty("release.info.vendor", ReleaseInfo.getVendor());
        String releaseInfoVersion = project.getProperty("release.info.version");
        if (Validator.isNull((String)releaseInfoVersion)) {
            project.setProperty("release.info.version", ReleaseInfo.getVersion());
        }
        if (!this._analyze) {
            return;
        }
        Analyzer analyzer = new Analyzer();
        analyzer.setBase(project.getBaseDir());
        File classesDir = new File(project.getBaseDir(), "classes");
        analyzer.setJar(classesDir);
        File file = new File(project.getBaseDir(), "bnd.bnd");
        if (file.exists()) {
            analyzer.setProperties(file);
        } else {
            analyzer.setProperty("Export-Package", "*");
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        Manifest manifest = analyzer.calcManifest();
        Attributes attributes = manifest.getMainAttributes();
        project.setProperty("export.packages", attributes.getValue("Export-Package"));
        project.setProperty("import.packages", attributes.getValue("Import-Package"));
        analyzer.close();
    }

    protected String execute(String command) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
        return StringUtil.read((InputStream)process.getInputStream());
    }

    protected String getBuildRevision() throws Exception {
        Project project = this.getProject();
        File projectDir = new File(project.getBaseDir(), project.getProperty(this._projectDirPropertyName));
        File gitDir = new File(projectDir, ".git");
        if (gitDir.exists()) {
            if (OSDetector.isWindows()) {
                return this.execute("cmd /c git rev-parse HEAD");
            }
            return this.execute("git rev-parse HEAD");
        }
        File svnDir = new File(projectDir, ".svn");
        if (svnDir.exists()) {
            if (OSDetector.isWindows()) {
                return this.execute("cmd /c svnversion .");
            }
            return this.execute("svnversion .");
        }
        return "";
    }

    protected String getDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(_PATTERN);
        return dateFormat.format(date);
    }
}

