/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers.icq.tcp;

import java.io.IOException;
import org.walluck.oscar.AIMOutputStream;

public class FileTransfer {
    public static final int FT_STATE_DISCONNECTED = 0;
    public static final int FT_STATE_HANDSHAKE = 1;
    public static final int FT_STATE_WAIT_FOR_CLIENT_INIT = 2;
    public static final int FT_STATE_WAIT_FOR_SERVER_INIT = 3;
    public static final int FT_STATE_WAIT_FOR_START = 4;
    public static final int FT_STATE_WAIT_FOR_FILE_INFO = 5;
    public static final int FT_STATE_RECEIVING_FILE = 6;
    public static final int FT_STATE_SENDING_FILE = 7;
    public static final int FT_STATE_CONFIRMING_FILE = 8;

    public void initClient(String localName, int numFiles, long totSize) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(17 + localName.length());
        buffer.writeByte(0);
        buffer.writeInt(0);
        buffer.writeInt(numFiles);
        buffer.writeInt((int)totSize);
        buffer.writeInt(100);
        buffer.writeString(localName);
    }

    public void initServer(String localName) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(5 + localName.length());
        buffer.writeByte(1);
        buffer.writeInt(100);
        buffer.writeString(localName);
    }

    public void info(String fileName, int fileSize) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(14 + fileName.length());
        buffer.writeShort(2);
        buffer.writeString(fileName);
        buffer.writeString("");
        buffer.writeInt(fileSize);
        buffer.writeInt(0);
        buffer.writeInt(100);
    }

    public void start(int filePos, int file) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(13);
        buffer.writeByte(3);
        buffer.writeInt(filePos);
        buffer.writeInt(100);
        buffer.writeInt(file);
    }

    public void setSpeed(int speed) throws IOException {
        AIMOutputStream buffer = new AIMOutputStream(5);
        buffer.writeByte(5);
        buffer.writeInt(speed);
    }
}

