/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.shopping.CouponCodeException;
import com.liferay.portlet.shopping.CouponDateException;
import com.liferay.portlet.shopping.CouponDescriptionException;
import com.liferay.portlet.shopping.CouponDiscountException;
import com.liferay.portlet.shopping.CouponEndDateException;
import com.liferay.portlet.shopping.CouponLimitCategoriesException;
import com.liferay.portlet.shopping.CouponLimitSKUsException;
import com.liferay.portlet.shopping.CouponMinimumOrderException;
import com.liferay.portlet.shopping.CouponNameException;
import com.liferay.portlet.shopping.CouponStartDateException;
import com.liferay.portlet.shopping.DuplicateCouponCodeException;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingCoupon;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.base.ShoppingCouponLocalServiceBaseImpl;
import com.liferay.util.PwdGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ShoppingCouponLocalServiceImpl
extends ShoppingCouponLocalServiceBaseImpl {
    public ShoppingCoupon addCoupon(long userId, String code, boolean autoCode, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        code = StringUtil.toUpperCase((String)code.trim());
        if (autoCode) {
            code = this.getCode();
        }
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)user.getTimeZone(), CouponStartDateException.class);
        Date endDate = null;
        if (!neverExpire) {
            endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)user.getTimeZone(), CouponEndDateException.class);
        }
        if (endDate != null && startDate.after(endDate)) {
            throw new CouponDateException();
        }
        Date now = new Date();
        this.validate(user.getCompanyId(), groupId, code, autoCode, name, description, limitCategories, limitSkus, minOrder, discount);
        long couponId = this.counterLocalService.increment();
        ShoppingCoupon coupon = this.shoppingCouponPersistence.create(couponId);
        coupon.setGroupId(groupId);
        coupon.setCompanyId(user.getCompanyId());
        coupon.setUserId(user.getUserId());
        coupon.setUserName(user.getFullName());
        coupon.setCreateDate(now);
        coupon.setModifiedDate(now);
        coupon.setCode(code);
        coupon.setName(name);
        coupon.setDescription(description);
        coupon.setStartDate(startDate);
        coupon.setEndDate(endDate);
        coupon.setActive(active);
        coupon.setLimitCategories(limitCategories);
        coupon.setLimitSkus(limitSkus);
        coupon.setMinOrder(minOrder);
        coupon.setDiscount(discount);
        coupon.setDiscountType(discountType);
        this.shoppingCouponPersistence.update((BaseModel)coupon);
        return coupon;
    }

    public void deleteCoupon(long couponId) throws PortalException, SystemException {
        ShoppingCoupon coupon = this.shoppingCouponPersistence.findByPrimaryKey(couponId);
        this.deleteCoupon(coupon);
    }

    public void deleteCoupon(ShoppingCoupon coupon) throws SystemException {
        this.shoppingCouponPersistence.remove((BaseModel)coupon);
    }

    public void deleteCoupons(long groupId) throws SystemException {
        List coupons = this.shoppingCouponPersistence.findByGroupId(groupId);
        for (ShoppingCoupon coupon : coupons) {
            this.deleteCoupon(coupon);
        }
    }

    public ShoppingCoupon getCoupon(long couponId) throws PortalException, SystemException {
        return this.shoppingCouponPersistence.findByPrimaryKey(couponId);
    }

    public ShoppingCoupon getCoupon(String code) throws PortalException, SystemException {
        code = StringUtil.toUpperCase((String)code.trim());
        return this.shoppingCouponPersistence.findByCode(code);
    }

    public List<ShoppingCoupon> search(long groupId, long companyId, String code, boolean active, String discountType, boolean andOperator, int start, int end) throws SystemException {
        return this.shoppingCouponFinder.findByG_C_C_A_DT(groupId, companyId, code, active, discountType, andOperator, start, end);
    }

    public int searchCount(long groupId, long companyId, String code, boolean active, String discountType, boolean andOperator) throws SystemException {
        return this.shoppingCouponFinder.countByG_C_C_A_DT(groupId, companyId, code, active, discountType, andOperator);
    }

    public ShoppingCoupon updateCoupon(long userId, long couponId, String name, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverExpire, boolean active, String limitCategories, String limitSkus, double minOrder, double discount, String discountType, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        ShoppingCoupon coupon = this.shoppingCouponPersistence.findByPrimaryKey(couponId);
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)user.getTimeZone(), CouponStartDateException.class);
        Date endDate = null;
        if (!neverExpire) {
            endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)user.getTimeZone(), CouponEndDateException.class);
        }
        if (endDate != null && startDate.after(endDate)) {
            throw new CouponDateException();
        }
        this.validate(coupon.getCompanyId(), coupon.getGroupId(), name, description, limitCategories, limitSkus, minOrder, discount);
        coupon.setModifiedDate(new Date());
        coupon.setName(name);
        coupon.setDescription(description);
        coupon.setStartDate(startDate);
        coupon.setEndDate(endDate);
        coupon.setActive(active);
        coupon.setLimitCategories(limitCategories);
        coupon.setLimitSkus(limitSkus);
        coupon.setMinOrder(minOrder);
        coupon.setDiscount(discount);
        coupon.setDiscountType(discountType);
        this.shoppingCouponPersistence.update((BaseModel)coupon);
        return coupon;
    }

    protected String getCode() throws SystemException {
        String code = PwdGenerator.getPassword((int)8, (String[])new String[]{"0123456789", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"});
        ShoppingCoupon coupon = this.shoppingCouponPersistence.fetchByCode(code);
        if (coupon != null) {
            return coupon.getCode();
        }
        return code;
    }

    protected void validate(long companyId, long groupId, String code, boolean autoCode, String name, String description, String limitCategories, String limitSkus, double minOrder, double discount) throws PortalException, SystemException {
        if (!autoCode) {
            if (Validator.isNull((String)code) || Validator.isNumber((String)code) || code.indexOf(44) != -1 || code.indexOf(32) != -1) {
                throw new CouponCodeException();
            }
            if (this.shoppingCouponPersistence.fetchByCode(code) != null) {
                throw new DuplicateCouponCodeException("{code=" + code + "}");
            }
        }
        this.validate(companyId, groupId, name, description, limitCategories, limitSkus, minOrder, discount);
    }

    protected void validate(long companyId, long groupId, String name, String description, String limitCategories, String limitSkus, double minOrder, double discount) throws PortalException, SystemException {
        ShoppingCategory category;
        if (Validator.isNull((String)name)) {
            throw new CouponNameException();
        }
        if (Validator.isNull((String)description)) {
            throw new CouponDescriptionException();
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        String[] categoryNames = StringUtil.split((String)limitCategories);
        Object object = categoryNames;
        int n = categoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String categoryName = object[n2];
            category = this.shoppingCategoryPersistence.fetchByG_N(groupId, categoryName);
            categoryIds.add(category.getCategoryId());
            ++n2;
        }
        ArrayList<Long> invalidCategoryIds = new ArrayList<Long>();
        object = categoryIds.iterator();
        while (object.hasNext()) {
            long categoryId = (Long)object.next();
            category = this.shoppingCategoryPersistence.fetchByPrimaryKey(categoryId);
            if (category != null && category.getGroupId() == groupId) continue;
            invalidCategoryIds.add(categoryId);
        }
        if (invalidCategoryIds.size() > 0) {
            CouponLimitCategoriesException clce = new CouponLimitCategoriesException();
            clce.setCategoryIds(invalidCategoryIds);
            throw clce;
        }
        String[] skus = StringUtil.split((String)limitSkus);
        ArrayList<String> invalidSkus = new ArrayList<String>();
        String[] stringArray = skus;
        int n3 = skus.length;
        int n4 = 0;
        while (n4 < n3) {
            String sku = stringArray[n4];
            ShoppingItem item = this.shoppingItemPersistence.fetchByC_S(companyId, sku);
            if (item != null) {
                ShoppingCategory category2 = item.getCategory();
                if (category2.getGroupId() != groupId) {
                    invalidSkus.add(sku);
                }
            } else {
                invalidSkus.add(sku);
            }
            ++n4;
        }
        if (invalidSkus.size() > 0) {
            CouponLimitSKUsException clskue = new CouponLimitSKUsException();
            clskue.setSkus(invalidSkus);
            throw clskue;
        }
        if (minOrder < 0.0) {
            throw new CouponMinimumOrderException();
        }
        if (discount < 0.0) {
            throw new CouponDiscountException();
        }
    }
}

