/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import com.liferay.util.mail.MailEngine;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;

public class MailingListMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(MailingListMessageListener.class);

    protected void doReceive(Message message) throws Exception {
        MailingListRequest mailingListRequest = (MailingListRequest)message.getPayload();
        Store store = null;
        Folder folder = null;
        javax.mail.Message[] messages = null;
        try {
            store = this.getStore(mailingListRequest);
            store.connect();
            folder = this.getFolder(store);
            messages = folder.getMessages();
            this.processMessages(mailingListRequest, messages);
        }
        catch (Throwable throwable) {
            if (folder != null && folder.isOpen()) {
                try {
                    folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                }
                catch (Exception exception) {}
                try {
                    folder.close(true);
                }
                catch (Exception exception) {}
            }
            if (store != null && store.isConnected()) {
                try {
                    store.close();
                }
                catch (MessagingException messagingException) {}
            }
            throw throwable;
        }
        if (folder != null && folder.isOpen()) {
            try {
                folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
            }
            catch (Exception exception) {}
            try {
                folder.close(true);
            }
            catch (Exception exception) {}
        }
        if (store != null && store.isConnected()) {
            try {
                store.close();
            }
            catch (MessagingException messagingException) {}
        }
    }

    protected Folder getFolder(Store store) throws Exception {
        Folder folder = store.getFolder("INBOX");
        if (!folder.exists()) {
            throw new MessagingException("Inbox not found");
        }
        folder.open(2);
        return folder;
    }

    protected Store getStore(MailingListRequest mailingListRequest) throws Exception {
        String protocol = mailingListRequest.getInProtocol();
        String host = mailingListRequest.getInServerName();
        int port = mailingListRequest.getInServerPort();
        String user = mailingListRequest.getInUserName();
        String password = mailingListRequest.getInPassword();
        Account account = Account.getInstance((String)protocol, (int)port);
        account.setHost(host);
        account.setPort(port);
        account.setUser(user);
        account.setPassword(password);
        Session session = MailEngine.getSession((Account)account);
        URLName urlName = new URLName(protocol, host, port, "", user, password);
        Store store = session.getStore(urlName);
        return store;
    }

    /*
     * Unable to fully structure code
     */
    protected void processMessage(MailingListRequest mailingListRequest, javax.mail.Message mailMessage) throws Exception {
        if (MBUtil.hasMailIdHeader(mailMessage)) {
            return;
        }
        from = null;
        addresses = mailMessage.getFrom();
        if (ArrayUtil.isNotEmpty((Object[])addresses)) {
            address = addresses[0];
            from = address instanceof InternetAddress != false ? ((InternetAddress)address).getAddress() : address.toString();
        }
        companyId = mailingListRequest.getCompanyId();
        groupId = mailingListRequest.getGroupId();
        categoryId = mailingListRequest.getCategoryId();
        if (MailingListMessageListener._log.isDebugEnabled()) {
            MailingListMessageListener._log.debug((Object)("Category id " + categoryId));
        }
        anonymous = false;
        user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)from);
        if (user == null) {
            if (!mailingListRequest.isAllowAnonymous()) {
                return;
            }
            anonymous = true;
            user = UserLocalServiceUtil.getUserById((long)companyId, (long)mailingListRequest.getUserId());
        }
        parentMessageId = MBUtil.getParentMessageId(mailMessage);
        if (MailingListMessageListener._log.isDebugEnabled()) {
            MailingListMessageListener._log.debug((Object)("Parent message id " + parentMessageId));
        }
        parentMessage = null;
        try {
            if (parentMessageId > 0L) {
                parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
            }
        }
        catch (NoSuchMessageException v0) {}
        if (MailingListMessageListener._log.isDebugEnabled()) {
            MailingListMessageListener._log.debug((Object)("Parent message " + parentMessage));
        }
        mbMailMessage = new MBMailMessage();
        MBUtil.collectPartContent((Part)mailMessage, mbMailMessage);
        PermissionCheckerUtil.setThreadValues(user);
        MailingListThreadLocal.setSourceMailingList(true);
        subject = MBUtil.getSubjectWithoutMessageId(mailMessage);
        serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19"));
        serviceContext.setScopeGroupId(groupId);
        inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
        try {
            if (parentMessage == null) {
                MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)anonymous, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
            }
            MBMessageServiceUtil.addMessage((long)parentMessage.getMessageId(), (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)anonymous, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl55:
        // 1 sources

    }

    protected void processMessages(MailingListRequest mailingListRequest, javax.mail.Message[] messages) throws Exception {
        javax.mail.Message[] messageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            javax.mail.Message message = messageArray[n2];
            try {
                this.processMessage(mailingListRequest, message);
            }
            finally {
                PermissionCheckerUtil.setThreadValues(null);
            }
            ++n2;
        }
    }
}

