/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MBMessageStagedModelDataHandler
extends BaseStagedModelDataHandler<MBMessage> {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(MBMessageStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        MBMessage message = MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId((String)uuid, (long)groupId);
        if (message != null) {
            MBMessageLocalServiceUtil.deleteMessage((MBMessage)message);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBMessage message) {
        return message.getSubject();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        if (message.getCategoryId() == -1L) {
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)message.getCategory(), (String)"parent");
        if (!message.isRoot()) {
            MBMessage parentMessage = MBMessageLocalServiceUtil.getMessage((long)message.getParentMessageId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)parentMessage, (String)"parent");
        }
        message.setPriority(message.getPriority());
        MBThread thread = message.getThread();
        Element messageElement = portletDataContext.getExportDataElement((ClassedModel)message);
        messageElement.addAttribute("question", String.valueOf(thread.isQuestion()));
        boolean hasAttachmentsFileEntries = message.getAttachmentsFileEntriesCount() > 0;
        messageElement.addAttribute("hasAttachmentsFileEntries", String.valueOf(hasAttachmentsFileEntries));
        if (hasAttachmentsFileEntries) {
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)fileEntry, (String)"weak");
            }
            long folderId = message.getAttachmentsFolderId();
            if (folderId != 0L) {
                message.setAttachmentsFolderId(folderId);
            }
        }
        portletDataContext.addClassedModel(messageElement, ExportImportPathUtil.getModelPath((StagedModel)message), (ClassedModel)message);
    }

    /*
     * Unable to fully structure code
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        if (!message.isRoot()) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, MBMessage.class, (long)message.getParentMessageId());
        }
        userId = portletDataContext.getUserId(message.getUserUuid());
        userName = message.getUserName();
        categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
        threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        threadId = MapUtil.getLong((Map)threadIds, (long)message.getThreadId(), (long)0L);
        messageIds = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        parentMessageId = MapUtil.getLong((Map)messageIds, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        element = portletDataContext.getImportDataStagedModelElement((StagedModel)message);
        inputStreamOVPs = this.getAttachments(portletDataContext, element, message);
        try {
            serviceContext = portletDataContext.createServiceContext((StagedModel)message);
            if (parentCategoryId != 0L && parentCategoryId != -1L && parentCategoryId == message.getCategoryId()) {
                StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, MBCategory.class, (long)parentCategoryId);
                parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
            }
            importedMessage = null;
            if (portletDataContext.isDataStrategyMirror()) {
                existingMessage = MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId((String)message.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingMessage == null) {
                    serviceContext.setUuid(message.getUuid());
                    importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                } else {
                    importedMessage = MBMessageLocalServiceUtil.updateMessage((long)userId, (long)existingMessage.getMessageId(), (String)message.getSubject(), (String)message.getBody(), inputStreamOVPs, new ArrayList<E>(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
                }
            } else {
                importedMessage = MBMessageLocalServiceUtil.addMessage((long)userId, (String)userName, (long)portletDataContext.getScopeGroupId(), (long)parentCategoryId, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (String)message.getFormat(), inputStreamOVPs, (boolean)message.getAnonymous(), (double)message.getPriority(), (boolean)message.getAllowPingbacks(), (ServiceContext)serviceContext);
            }
            importedMessage.setAnswer(message.getAnswer());
            if (importedMessage.isRoot()) {
                MBThreadLocalServiceUtil.updateQuestion((long)importedMessage.getThreadId(), (boolean)GetterUtil.getBoolean((String)element.attributeValue("question")));
            }
            threadIds.put(message.getThreadId(), importedMessage.getThreadId());
            portletDataContext.importClassedModel((ClassedModel)message, (ClassedModel)importedMessage);
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl40:
        // 1 sources

    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        MBThread existingThread;
        TrashHandler trashHandler;
        TrashHandler trashHandler2;
        long userId = portletDataContext.getUserId(message.getUserUuid());
        MBMessage existingMessage = MBMessageLocalServiceUtil.fetchMBMessageByUuidAndGroupId((String)message.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingMessage == null) {
            return;
        }
        if (existingMessage.isInTrash() && (trashHandler2 = existingMessage.getTrashHandler()).isRestorable(existingMessage.getMessageId())) {
            trashHandler2.restoreTrashEntry(userId, existingMessage.getMessageId());
        }
        if (existingMessage.isInTrashContainer() && (trashHandler = (existingThread = existingMessage.getThread()).getTrashHandler()).isRestorable(existingThread.getThreadId())) {
            trashHandler.restoreTrashEntry(userId, existingThread.getThreadId());
        }
    }

    protected List<ObjectValuePair<String, InputStream>> getAttachments(PortletDataContext portletDataContext, Element messageElement, MBMessage message) {
        boolean hasAttachmentsFileEntries = GetterUtil.getBoolean((String)messageElement.attributeValue("hasAttachmentsFileEntries"));
        if (!hasAttachmentsFileEntries) {
            return Collections.emptyList();
        }
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        List attachmentElements = portletDataContext.getReferenceDataElements(messageElement, DLFileEntry.class, "weak");
        for (Element attachmentElement : attachmentElements) {
            String path = attachmentElement.attributeValue("path");
            FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
            InputStream inputStream = null;
            String binPath = attachmentElement.attributeValue("bin-path");
            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                try {
                    inputStream = FileEntryUtil.getContentStream(fileEntry);
                }
                catch (Exception exception) {}
            } else {
                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
            }
            if (inputStream == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                continue;
            }
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileEntry.getTitle(), (Object)inputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        if (inputStreamOVPs.isEmpty()) {
            _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
        }
        return inputStreamOVPs;
    }
}

