/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.CombinedFacetAccessible;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.PrimitiveLongArrayWrapper;
import com.browseengine.bobo.facets.impl.GroupByFacetCountCollector;
import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.sort.DocIDPriorityQueue;
import com.browseengine.bobo.sort.SortCollector;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.ListMerger;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;

public class SortCollectorImpl
extends SortCollector {
    private static final Comparator<MyScoreDoc> MERGE_COMPATATOR = new Comparator<MyScoreDoc>(){

        @Override
        public int compare(MyScoreDoc o1, MyScoreDoc o2) {
            int v;
            Comparable s1 = o1.getValue();
            Comparable s2 = o2.getValue();
            int r = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : ((v = s1.compareTo(s2)) == 0 ? o1.doc + o1.queue.base - o2.doc - o2.queue.base : v));
            return r;
        }
    };
    private final LinkedList<DocIDPriorityQueue> _pqList;
    private final int _numHits;
    private int _totalHits;
    private int _totalGroups;
    private ScoreDoc _bottom;
    private ScoreDoc _tmpScoreDoc;
    private boolean _queueFull;
    private DocComparator _currentComparator;
    private DocComparatorSource _compSource;
    private DocIDPriorityQueue _currentQueue;
    private BoboIndexReader _currentReader = null;
    private FacetCountCollector _facetCountCollector;
    private FacetCountCollector[] _facetCountCollectorMulti = null;
    private final boolean _doScoring;
    private Scorer _scorer;
    private final int _offset;
    private final int _count;
    private final Browsable _boboBrowser;
    private final boolean _collectDocIdCache;
    private CombinedFacetAccessible[] _groupAccessibles;
    private final List<FacetAccessible>[] _facetAccessibleLists;
    private final Int2ObjectOpenHashMap<ScoreDoc> _currentValueDocMaps;
    private SortCollector.CollectorContext _currentContext;
    private int[] _currentDocIdArray;
    private float[] _currentScoreArray;
    private int _docIdArrayCursor = 0;
    private int _docIdCacheCapacity = 0;
    private Set<String> _termVectorsToFetch;

    public SortCollectorImpl(DocComparatorSource compSource, SortField[] sortFields, Browsable boboBrowser, int offset, int count, boolean doScoring, boolean fetchStoredFields, Set<String> termVectorsToFetch, String[] groupBy, int maxPerGroup, boolean collectDocIdCache) {
        super(sortFields, fetchStoredFields);
        assert (offset >= 0 && count >= 0);
        this._boboBrowser = boboBrowser;
        this._compSource = compSource;
        this._pqList = new LinkedList();
        this._numHits = offset + count;
        this._offset = offset;
        this._count = count;
        this._totalHits = 0;
        this._totalGroups = 0;
        this._queueFull = false;
        this._doScoring = doScoring;
        this._tmpScoreDoc = new MyScoreDoc();
        this._termVectorsToFetch = termVectorsToFetch;
        boolean bl = this._collectDocIdCache = collectDocIdCache || groupBy != null;
        if (groupBy != null && groupBy.length != 0) {
            ArrayList groupByList = new ArrayList(groupBy.length);
            for (String field : groupBy) {
                FacetHandler<?> handler = boboBrowser.getFacetHandler(field);
                if (handler == null) continue;
                groupByList.add(handler);
            }
            if (groupByList.size() > 0) {
                this.groupByMulti = groupByList.toArray(new FacetHandler[0]);
                this.groupBy = this.groupByMulti[0];
            }
            if (this.groupBy != null && this._count > 0) {
                if (this.groupByMulti.length == 1) {
                    this._currentValueDocMaps = new Int2ObjectOpenHashMap(this._count);
                    this._facetAccessibleLists = null;
                } else {
                    this._currentValueDocMaps = null;
                    this._facetCountCollectorMulti = new FacetCountCollector[groupByList.size() - 1];
                    this._facetAccessibleLists = new List[this._facetCountCollectorMulti.length];
                    for (int i = 0; i < this._facetCountCollectorMulti.length; ++i) {
                        this._facetAccessibleLists[i] = new LinkedList<FacetAccessible>();
                    }
                }
                if (this._collectDocIdCache) {
                    this.contextList = new LinkedList();
                    this.docidarraylist = new LinkedList();
                    if (doScoring) {
                        this.scorearraylist = new LinkedList();
                    }
                }
            } else {
                this._currentValueDocMaps = null;
                this._facetAccessibleLists = null;
            }
        } else {
            this._currentValueDocMaps = null;
            this._facetAccessibleLists = null;
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this._collector == null ? true : this._collector.acceptsDocsOutOfOrder();
    }

    public void collect(int doc) throws IOException {
        ++this._totalHits;
        if (this.groupBy != null) {
            if (this._facetCountCollectorMulti != null) {
                for (int i = 0; i < this._facetCountCollectorMulti.length; ++i) {
                    if (this._facetCountCollectorMulti[i] == null) continue;
                    this._facetCountCollectorMulti[i].collect(doc);
                }
                if (this._count > 0) {
                    float score;
                    float f = score = this._doScoring ? this._scorer.score() : 0.0f;
                    if (this._collectDocIdCache) {
                        if (this._totalHits > this._docIdCacheCapacity) {
                            this._currentDocIdArray = (int[])intarraymgr.get(BLOCK_SIZE);
                            this.docidarraylist.add(this._currentDocIdArray);
                            if (this._doScoring) {
                                this._currentScoreArray = (float[])floatarraymgr.get(BLOCK_SIZE);
                                this.scorearraylist.add(this._currentScoreArray);
                            }
                            this._docIdCacheCapacity += BLOCK_SIZE;
                            this._docIdArrayCursor = 0;
                        }
                        this._currentDocIdArray[this._docIdArrayCursor] = doc;
                        if (this._doScoring) {
                            this._currentScoreArray[this._docIdArrayCursor] = score;
                        }
                        ++this._docIdArrayCursor;
                        ++this._currentContext.length;
                    }
                }
                return;
            }
            if (this._count > 0) {
                float score;
                float f = score = this._doScoring ? this._scorer.score() : 0.0f;
                if (this._collectDocIdCache) {
                    if (this._totalHits > this._docIdCacheCapacity) {
                        this._currentDocIdArray = (int[])intarraymgr.get(BLOCK_SIZE);
                        this.docidarraylist.add(this._currentDocIdArray);
                        if (this._doScoring) {
                            this._currentScoreArray = (float[])floatarraymgr.get(BLOCK_SIZE);
                            this.scorearraylist.add(this._currentScoreArray);
                        }
                        this._docIdCacheCapacity += BLOCK_SIZE;
                        this._docIdArrayCursor = 0;
                    }
                    this._currentDocIdArray[this._docIdArrayCursor] = doc;
                    if (this._doScoring) {
                        this._currentScoreArray[this._docIdArrayCursor] = score;
                    }
                    ++this._docIdArrayCursor;
                    ++this._currentContext.length;
                }
                this._tmpScoreDoc.doc = doc;
                this._tmpScoreDoc.score = score;
                if (!this._queueFull || this._currentComparator.compare(this._bottom, this._tmpScoreDoc) > 0) {
                    int order = ((FacetDataCache)this.groupBy.getFacetData((BoboIndexReader)this._currentReader)).orderArray.get(doc);
                    ScoreDoc pre = (ScoreDoc)this._currentValueDocMaps.get(order);
                    if (pre != null) {
                        if (this._currentComparator.compare(pre, this._tmpScoreDoc) > 0) {
                            ScoreDoc tmp = pre;
                            this._bottom = this._currentQueue.replace(this._tmpScoreDoc, pre);
                            this._currentValueDocMaps.put(order, (Object)this._tmpScoreDoc);
                            this._tmpScoreDoc = tmp;
                        }
                    } else if (this._queueFull) {
                        MyScoreDoc tmp = (MyScoreDoc)this._bottom;
                        this._currentValueDocMaps.remove(((FacetDataCache)this.groupBy.getFacetData((BoboIndexReader)tmp.reader)).orderArray.get(tmp.doc));
                        this._bottom = this._currentQueue.replace(this._tmpScoreDoc);
                        this._currentValueDocMaps.put(order, (Object)this._tmpScoreDoc);
                        this._tmpScoreDoc = tmp;
                    } else {
                        MyScoreDoc tmp = new MyScoreDoc(doc, score, this._currentQueue, this._currentReader);
                        this._bottom = this._currentQueue.add(tmp);
                        this._currentValueDocMaps.put(order, (Object)tmp);
                        this._queueFull = this._currentQueue.size >= this._numHits;
                    }
                }
            }
        } else if (this._count > 0) {
            float score;
            float f = score = this._doScoring ? this._scorer.score() : 0.0f;
            if (this._queueFull) {
                this._tmpScoreDoc.doc = doc;
                this._tmpScoreDoc.score = score;
                if (this._currentComparator.compare(this._bottom, this._tmpScoreDoc) > 0) {
                    ScoreDoc tmp = this._bottom;
                    this._bottom = this._currentQueue.replace(this._tmpScoreDoc);
                    this._tmpScoreDoc = tmp;
                }
            } else {
                this._bottom = this._currentQueue.add(new MyScoreDoc(doc, score, this._currentQueue, this._currentReader));
                boolean bl = this._queueFull = this._currentQueue.size >= this._numHits;
            }
        }
        if (this._collector != null) {
            this._collector.collect(doc);
        }
    }

    private void collectTotalGroups() {
        if (this._facetCountCollector instanceof GroupByFacetCountCollector) {
            this._totalGroups += ((GroupByFacetCountCollector)this._facetCountCollector).getTotalGroups();
            return;
        }
        BigSegmentedArray count = this._facetCountCollector.getCountDistribution();
        for (int i = 0; i < count.size(); ++i) {
            int c = count.get(i);
            if (c <= 0) continue;
            ++this._totalGroups;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        assert (reader instanceof BoboIndexReader);
        this._currentReader = (BoboIndexReader)reader;
        this._currentComparator = this._compSource.getComparator(reader, docBase);
        this._currentQueue = new DocIDPriorityQueue(this._currentComparator, this._numHits, docBase);
        if (this.groupBy != null) {
            if (this._facetCountCollectorMulti != null) {
                int i;
                for (i = 0; i < this._facetCountCollectorMulti.length; ++i) {
                    this._facetCountCollectorMulti[i] = this.groupByMulti[i].getFacetCountCollectorSource(null, null, true).getFacetCountCollector(this._currentReader, docBase);
                }
                this._facetCountCollector = this._facetCountCollectorMulti[0];
                if (this._facetAccessibleLists != null) {
                    for (i = 0; i < this._facetCountCollectorMulti.length; ++i) {
                        this._facetAccessibleLists[i].add(this._facetCountCollectorMulti[i]);
                    }
                }
            }
            if (this._currentValueDocMaps != null) {
                this._currentValueDocMaps.clear();
            }
            if (this.contextList != null) {
                this._currentContext = new SortCollector.CollectorContext(this._currentReader, docBase, this._currentComparator);
                this.contextList.add(this._currentContext);
            }
        }
        MyScoreDoc myScoreDoc = (MyScoreDoc)this._tmpScoreDoc;
        myScoreDoc.queue = this._currentQueue;
        myScoreDoc.reader = this._currentReader;
        myScoreDoc.sortValue = null;
        this._pqList.add(this._currentQueue);
        this._queueFull = false;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this._scorer = scorer;
        this._currentComparator.setScorer(scorer);
    }

    @Override
    public int getTotalHits() {
        return this._totalHits;
    }

    @Override
    public int getTotalGroups() {
        return this._totalHits;
    }

    public CombinedFacetAccessible[] getGroupAccessibles() {
        return this._groupAccessibles;
    }

    @Override
    public BrowseHit[] topDocs() throws IOException {
        ArrayList<MyScoreDoc> resList;
        int i;
        ArrayList iterList = new ArrayList(this._pqList.size());
        for (DocIDPriorityQueue pq : this._pqList) {
            int count = pq.size();
            MyScoreDoc[] resList2 = new MyScoreDoc[count];
            for (i = count - 1; i >= 0; --i) {
                resList2[i] = (MyScoreDoc)pq.pop();
            }
            iterList.add(Arrays.asList(resList2).iterator());
        }
        if (this._count > 0) {
            if (this.groupBy == null) {
                resList = ListMerger.mergeLists(this._offset, this._count, iterList, MERGE_COMPATATOR);
            } else {
                int rawGroupValueType = 0;
                PrimitiveLongArrayWrapper primitiveLongArrayWrapperTmp = new PrimitiveLongArrayWrapper(null);
                Object rawGroupValue = null;
                if (this._facetAccessibleLists != null) {
                    this._groupAccessibles = new CombinedFacetAccessible[this._facetAccessibleLists.length];
                    for (i = 0; i < this._facetAccessibleLists.length; ++i) {
                        this._groupAccessibles[i] = new CombinedFacetAccessible(new FacetSpec(), this._facetAccessibleLists[i]);
                    }
                }
                resList = new ArrayList(this._count);
                Iterator<MyScoreDoc> mergedIter = ListMerger.mergeLists(iterList, MERGE_COMPATATOR);
                HashSet<PrimitiveLongArrayWrapper> groupSet = new HashSet<PrimitiveLongArrayWrapper>(this._offset + this._count);
                int offsetLeft = this._offset;
                while (mergedIter.hasNext()) {
                    MyScoreDoc scoreDoc = mergedIter.next();
                    Object[] vals = this.groupBy.getRawFieldValues(scoreDoc.reader, scoreDoc.doc);
                    rawGroupValue = null;
                    if (vals != null && vals.length > 0) {
                        rawGroupValue = vals[0];
                    }
                    if (rawGroupValueType == 0 && rawGroupValue != null) {
                        rawGroupValueType = rawGroupValue instanceof long[] ? 2 : 1;
                    }
                    if (rawGroupValueType == 2) {
                        primitiveLongArrayWrapperTmp.data = (long[])rawGroupValue;
                        rawGroupValue = primitiveLongArrayWrapperTmp;
                    }
                    if (groupSet.contains(rawGroupValue)) continue;
                    if (offsetLeft > 0) {
                        --offsetLeft;
                    } else {
                        resList.add(scoreDoc);
                        if (resList.size() >= this._count) break;
                    }
                    groupSet.add(new PrimitiveLongArrayWrapper(primitiveLongArrayWrapperTmp.data));
                }
            }
        } else {
            resList = Collections.EMPTY_LIST;
        }
        Map<String, FacetHandler<?>> facetHandlerMap = this._boboBrowser.getFacetHandlerMap();
        return SortCollectorImpl.buildHits(resList.toArray(new MyScoreDoc[resList.size()]), this._sortFields, facetHandlerMap, this._fetchStoredFields, this._termVectorsToFetch, this.groupBy, this._groupAccessibles);
    }

    protected static BrowseHit[] buildHits(MyScoreDoc[] scoreDocs, SortField[] sortFields, Map<String, FacetHandler<?>> facetHandlerMap, boolean fetchStoredFields, Set<String> termVectorsToFetch, FacetHandler<?> groupBy, CombinedFacetAccessible[] groupAccessibles) throws IOException {
        BrowseHit[] hits = new BrowseHit[scoreDocs.length];
        Collection<FacetHandler<?>> facetHandlers = facetHandlerMap.values();
        for (int i = scoreDocs.length - 1; i >= 0; --i) {
            MyScoreDoc fdoc = scoreDocs[i];
            BoboIndexReader reader = fdoc.reader;
            BrowseHit hit = new BrowseHit();
            if (fetchStoredFields) {
                hit.setStoredFields(reader.document(fdoc.doc));
            }
            if (termVectorsToFetch != null && termVectorsToFetch.size() > 0) {
                HashMap<String, BrowseHit.TermFrequencyVector> tvMap = new HashMap<String, BrowseHit.TermFrequencyVector>();
                hit.setTermFreqMap(tvMap);
                for (String field : termVectorsToFetch) {
                    TermFreqVector tv = reader.getTermFreqVector(fdoc.doc, field);
                    if (tv == null) continue;
                    int[] freqs = tv.getTermFrequencies();
                    String[] terms = tv.getTerms();
                    tvMap.put(field, new BrowseHit.TermFrequencyVector(terms, freqs));
                }
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            HashMap<String, Object[]> rawMap = new HashMap<String, Object[]>();
            for (FacetHandler<?> facetHandler : facetHandlers) {
                map.put(facetHandler.getName(), facetHandler.getFieldValues(reader, fdoc.doc));
                rawMap.put(facetHandler.getName(), facetHandler.getRawFieldValues(reader, fdoc.doc));
            }
            hit.setFieldValues(map);
            hit.setRawFieldValues(rawMap);
            hit.setDocid(fdoc.doc + fdoc.queue.base);
            hit.setScore(fdoc.score);
            hit.setComparable(fdoc.getValue());
            if (groupBy != null) {
                hit.setGroupField(groupBy.getName());
                hit.setGroupValue(hit.getField(groupBy.getName()));
                hit.setRawGroupValue(hit.getRawField(groupBy.getName()));
                if (groupAccessibles != null && hit.getGroupValue() != null && groupAccessibles != null && groupAccessibles.length > 0) {
                    BrowseFacet facet = groupAccessibles[0].getFacet(hit.getGroupValue());
                    hit.setGroupHitsCount(facet.getFacetValueHitCount());
                }
            }
            hits[i] = hit;
        }
        return hits;
    }

    static class MyScoreDoc
    extends ScoreDoc {
        private static final long serialVersionUID = 1L;
        DocIDPriorityQueue queue;
        BoboIndexReader reader;
        Comparable sortValue;

        public MyScoreDoc() {
            this(0, 0.0f, null, null);
        }

        public MyScoreDoc(int docid, float score, DocIDPriorityQueue queue, BoboIndexReader reader) {
            super(docid, score);
            this.queue = queue;
            this.reader = reader;
            this.sortValue = null;
        }

        Comparable getValue() {
            if (this.sortValue == null) {
                this.sortValue = this.queue.sortValue(this);
            }
            return this.sortValue;
        }
    }
}

